{{-- view/user/register.blade.php --}}

@extends('layouts.base')

@section('title', __('Register'))

@section('content')
    <div class="wrap">
        <h2>{{ __('Create account') }}</h2>

        @if ($errors->any())
            <div class="alert danger">
                <strong>{{ __('Errors') }} :</strong>
                <ul style="margin:6px 0 0 16px;">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <div class="">
            <section class="profile-card profile-card--main">


                <form method="POST" action="{{ route('register.post', ['locale' => app()->getLocale()]) }}" class="profile-form">
                    @csrf

                    <div class="" style="padding:16px; border-radius:12px; border:1px solid #e5e7eb; background:#fff;">
            
                        <div class="profile-card profile-card--main">
                            <div class="field-grid">
                                <div class="field-group">
                                    <label for="firstname">{{ __('Firstname') }} *</label>
                                    <input id="firstname" type="text" name="firstname" value="{{ old('firstname') }}" required>
                                </div>
                                <div class="field-group">
                                    <label for="lastname">{{ __('Lastname') }} *</label>
                                    <input id="lastname" type="text" name="lastname" value="{{ old('lastname') }}" required>
                                </div>
                            </div>
                
                            <div class="field-grid">
                                <div class="field-group">
                                    <label>{{ __('Address 1') }}</label>
                                    <input type="text" name="address1" value="{{ old('address1') }}">
                                </div>
                                <div class="field-group">
                                    <label>{{ __('Address 2') }}</label>
                                    <input type="text" name="address2" value="{{ old('address2') }}">
                                </div>
                            </div>

                            <div class="field-grid">
                                <div class="field-group">
                                    <label>{{ __('Postcode') }}</label>
                                    <input type="text" name="postcode" value="{{ old('postcode') }}">
                                </div>
                                <div class="field-group">
                                    <label>{{ __('City') }}</label>
                                    <input type="text" name="city" value="{{ old('city') }}">
                                </div>
                                <div class="field-group">
                                    <label>{{ __('Country (ISO)') }}</label>
                                    <input type="text" name="country_isocode" maxlength="3" value="{{ old('country_isocode') }}" placeholder="FR, UA...">
                                </div>
                            </div>
         
                            <div class="field-grid">
                                <div class="field-group">
                                    <label>{{ __('Phone') }} *</label>
                                    <input type="text" name="phone" value="{{ old('phone') }}" required>
                                </div>
                                <div class="field-group">
                                    <label>{{ __('Email') }} *</label>
                                    <input type="email" name="email" value="{{ old('email') }}" required>
                                </div>
                                <div class="field-group">
                                    <label>{{ __('Email Verification') }} *</label>
                                    <input type="email" name="email_verification" value="" required>
                                </div>
                                {{-- <div class="field-group">
                                    <div style="font-size:.85rem; color:#6b7280; margin-top:4px">
                                        {{ __('Email can be changed; verification may be required.') }}
                                    </div>
                                </div> --}}
                            </div>



                            <div class="field-grid">
                                    <div class="field-group">
                                        <label>{{ __('Password')}} *</label>
                                        <input type="password" name="password" placeholder="••••••••">
                                    </div>
                                    <div class="field-group">
                                        <label for="password_confirmation">{{ __('Confirm password') }}</label>
                                        <input id="password_confirmation" type="password" name="password_confirmation" required>
                                    </div>
                                </div>

                            </div>
                    </div>

                    <div class="actions" style="margin-top:16px;">
                    <a href="{{ lr('login') }}" class="btn ghost">{{ __('Already registered?') }}</a>
                    <button type="submit" class="btn primary">{{ __('register') }}</button>
                    </div>
                </form>
            </section>
        </div>
    </div>
@endsection