<?php

    use Illuminate\Support\Facades\Route;
    use App\Http\Controllers\Api\WaypointApiController;
    use App\Http\Controllers\Api\AuthTokenController;

    // Stateless API group
    Route::middleware('api')->group(function () {
        // Simple test endpoint
        Route::get('/health', fn () => ['status' => 'ok', 'time' => now()->toIso8601String()]);
    });

    // Auth (create and revoke tokens)
    Route::post('/auth/token', [AuthTokenController::class, 'store']);    // login -> token
    Route::post('/auth/logout', [AuthTokenController::class, 'destroy'])  // revoke token
        ->middleware('auth:sanctum');

    // Waypoint CRUD protected by token
    Route::middleware('auth:sanctum')->group(function () {
        Route::apiResource('waypoints', WaypointApiController::class);
        // Optional: search/filter endpoints
        // Route::get('waypoints/search', [WaypointApiController::class, 'search']);
    });

    // Protected route for toggling a favorite
    Route::middleware('auth:sanctum')->group(function () {
        // … your other CRUD routes
        Route::patch('/waypoints/{waypoint}/favorite', [WaypointApiController::class, 'toggleFavorite']);
    });
