<?php

use Illuminate\Support\Facades\Route;
use App\Http\Middleware\SetLocale;
use App\Http\Controllers\PointController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\UserProfileController;
use App\Models\Point;
use App\Http\Controllers\ContactController;
use Illuminate\Support\Facades\Mail;
use App\Mail\TestBrevoMail;
use App\Http\Controllers\WelcomeController;
use App\Http\Controllers\Admin\AdminPointController;
use App\Http\Controllers\Admin\AdminUserController;
use App\Http\Middleware\EnsureAdminPro;
use App\Http\Controllers\ReportingController;
use App\Http\Controllers\Admin\ReportingAdminController;
use App\Http\Controllers\Pro\ProPointController;
use App\Http\Controllers\Pro\ProUserController;
use App\Http\Controllers\Pro\ProSocietyController;
use App\Http\Controllers\Pro\ProItineraryController;
use App\Http\Controllers\Admin\AdminItineraryController;
use App\Http\Controllers\ItineraryController;
use App\Http\Controllers\Admin\AdminSocietyController;
use Illuminate\Foundation\Auth\EmailVerificationRequest;
use Illuminate\Http\Request;
use App\Http\Controllers\Auth\ForgotPasswordController;
use App\Http\Controllers\Auth\ResetPasswordController;
use App\Http\Controllers\MyItinerariesController;
use App\Http\Controllers\Auth\VerificationNoticeController;
use Illuminate\Auth\Events\Verified;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Arr;


// ------------------------------------------------------------
// 0) Root → redirect to /{locale}
// ------------------------------------------------------------
Route::get('/', function (\Illuminate\Http\Request $request) {
    $supported  = array_keys(config('locales.supported'));
    $default    = config('locales.default', 'fr');

    $locale = session('locale')
           ?: $request->getPreferredLanguage($supported)
           ?: $default;

    if (! in_array($locale, $supported, true)) {
        $locale = $default;
    }

    return redirect('/'.$locale);
})->name('home');





// ------------------------------------------------------------
// 1) Constraints & localized group
// ------------------------------------------------------------
$codes = implode('|', array_keys(config('locales.supported')));
Route::pattern('locale', $codes);

Route::group([
    'prefix' => '{locale}',
    'middleware' => [SetLocale::class],
], function () {

    // Home
    Route::get('/', [PointController::class, 'home_index'])->name('welcome');

    // Public pages (map & search)
    Route::get('/map',    [PointController::class, 'displayMap_index'])->name('map');
    Route::get('/search', [PointController::class, 'search'])->name('search');
    Route::post('/search', [PointController::class, 'result'])->name('search.post');

    // Token-based public pages

    Route::get('/w/{token}', [PointController::class, 'publicView'])
        ->where('token', '[A-Za-z0-9\-\_=]+')
        ->name('points.public.readonly');

    Route::get('/wp/{token}', [PointController::class, 'publicShow'])
        ->where('token', '[A-Za-z0-9\-\_=]+')
        ->name('points.public');

    // Contact (simple form)
    Route::post('/contact', [ContactController::class, 'send'])
        ->name('contact.send')
        ->middleware('throttle:5,1'); // simple anti-spam (5 req/min)

    Route::post('/points/{token}/favorite', [\App\Http\Controllers\PointController::class, 'toggleFavorite'])
        ->middleware('auth')
        ->name('points.favorite');


    /*    Email verification routes
    */
    Route::get('/email/verify', function (Request $request) {
            return view('auth.verify-email');
        })->middleware('auth')->name('verification.notice');
           
    Route::post('/email/verification-notification', function (Request $request) {
        if ($request->user()->hasVerifiedEmail()) {
            return back()->with('ok', __('Email already verified.'));
        }
        $request->user()->sendEmailVerificationNotification();
        return back()->with('ok', __('Verification email resent.'));
    })->middleware(['auth','throttle:6,1'])->name('verification.send');
        




    // Mes itinéraires (utilisateur)
    Route::get('/itineraries', [\App\Http\Controllers\MyItinerariesController::class, 'index'])
    ->name('itins.mine');

    // On réutilise votre action "map" (ItineraryController@map) si elle existe déjà :
    Route::get('/itineraries/{itinerary}/map', [\App\Http\Controllers\ItineraryController::class, 'map'])
        ->whereNumber('itinerary')
        ->name('itins.user.map');


    // Logout (POST)
    Route::post('/logout', function (\Illuminate\Http\Request $request) {
        \Illuminate\Support\Facades\Auth::guard('web')->logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();
        return redirect('/'.app()->getLocale());
    })->name('logout');
    


    // ------------------- Authenticated area -------------------
    Route::middleware('auth')->group(function () {
     
        Route::middleware(['auth','not.blocked'])->group(function () {
            Route::post('/points', [PointController::class, 'store'])->name('points.store');
            // ...
        });

        Route::middleware(['auth', 'can:is-super-admin']) // adapte ton middleware/policy
            ->prefix('admin')
            ->name('admin.')
            ->group(function () {
                Route::get('/users/import',  [AdminUserController::class, 'importForm'])->name('users.import.form');
                Route::post('/users/import', [AdminUserController::class, 'importStore'])->name('users.import.store');
        });

        // Points CRUD
        Route::get('/points', [PointController::class, 'point_index'])->name('points.index');
        Route::post('/points', [PointController::class, 'store'])->name('points.store');
        Route::put('/points/{point}', [PointController::class, 'update'])
            ->whereNumber('point')
            ->name('points.update');
        Route::delete('/points/{point}', [PointController::class, 'destroy'])
            ->whereNumber('point')
            ->name('points.destroy');

        Route::post('/points/{token}/share', [PointController::class, 'share'])
            ->where('token', '[A-Za-z0-9\-\_=]+')
            ->name('points.share');

        Route::post('/points/{point}/sharePoint', [PointController::class, 'sharePoint'])
            ->where('point', '[A-Za-z0-9\-\_=]+')
            ->name('points.sharePoint');



        // Photo/serial helpers
        Route::put('/points/serial/photo', [PointController::class, 'updatePhotoBySerial'])->name('points.update.photo');
        Route::put('/points/serial/{serial}', [PointController::class, 'updateBySerial'])->name('points.update.serial');



        // Account / profile (UserController)
        Route::get('/user/edit', [UserController::class, 'edit'])->name('user.edit');
        Route::put('/user/{user}', [UserController::class, 'update'])
            ->whereNumber('user')
            ->name('user.update');
        Route::delete('/user/{user}', [UserController::class, 'destroy'])
            ->whereNumber('user')
            ->name('user.destroy');



        // Email change (with verification code)
        Route::post('/user/email/request-change', [UserController::class, 'requestEmailChange'])->name('user.email.requestChange');
        Route::post('/user/email/confirm-change', [UserController::class, 'confirmEmailChange'])->name('user.email.confirmChange');
        Route::post('/user/{user}/verify-email', [UserController::class, 'verifyEmail'])
            ->whereNumber('user')
            ->name('user.verifyEmail');



        // User profile (separate profile resource/controller)
        Route::get('/account',  [UserProfileController::class, 'edit'])->name('profile.edit');
        Route::put('/account',  [UserProfileController::class, 'update'])->name('profile.update');



        // Email change via code (alt flow) — keep if both are used
        Route::post('/account/email/request-code', [UserController::class, 'requestEmailChangeCode'])
            ->name('profile.email.requestCode');
        Route::post('/account/email/confirm', [UserController::class, 'confirmEmailChange'])
            ->name('profile.email.confirm');


        // Progress saving for itineraries
        Route::post('/itineraries/{itinerary}/progress', [ItineraryController::class, 'saveProgress'])
            ->whereNumber('itinerary')
            ->name('itins.progress.save');
            
        Route::get('/my-itineraries', [\App\Http\Controllers\MyItinerariesController::class, 'index'])
            ->name('itins.mine');


    });

    // 
    Route::middleware('guest')->group(function () {
        Route::get('/login', fn() => view('user.login'))->name('login');        
        Route::post('/login', [\App\Http\Controllers\AuthController::class, 'login'])->name('login.post');

        Route::get('/register', fn() => view('user.register'))->name('register');
        Route::post('/register', [\App\Http\Controllers\AuthController::class, 'register'])->name('register.post');
    });

  


    
    // ------------------------------------------------------------
    // 3) Super admin area
    // ------------------------------------------------------------
    // Route::middleware(['web', 'auth', \App\Http\Middleware\EnsureUserIsSuperAdmin::class])
    //     ->prefix('admin')
    //     ->name('admin.')
    //     ->group(function () {
    
    Route::middleware(['auth'])
        ->prefix('admin')
       // ->whereAlpha('locale')
        ->name('admin.')
        ->group(function () {
    
            // Bulk tools
            Route::post('/waypoints/bulk/fill-addresses', [\App\Http\Controllers\Admin\AdminWaypointController::class, 'bulkFillAddresses'])
                ->name('points.bulk.fillAddresses');
    
            Route::post('/waypoints/bulk/generate-qrcodes', [\App\Http\Controllers\Admin\AdminWaypointController::class, 'bulkGenerateQrcodes'])
                ->name('points.bulk.generateQrcodes');
            Route::post('/points/generate-serials', [AdminPointController::class, 'generateSerials'])->name('points.generateSerials');
            Route::post('/points/generate-missing-qr', [AdminPointController::class, 'generateMissingQr'])->name('points.generateMissingQr');
    
            // Points
            Route::get('/points',            [AdminPointController::class, 'index'])->name('points.index');
            Route::get('/points/{point}',    [AdminPointController::class, 'show'])->name('points.show');
            Route::get('/points/{point}/edit',[AdminPointController::class, 'edit'])->name('points.edit');
            Route::put('/points/{point}',    [AdminPointController::class, 'update'])->name('points.update');
    
            // Users
            Route::get('/users',             [AdminUserController::class, 'index'])->name('users.index');
            Route::get('/users/{user}',      [AdminUserController::class, 'show'])->name('users.show');
            Route::get('/users/{user}/edit', [AdminUserController::class, 'edit'])->name('users.edit');
            Route::put('/users/{user}',      [AdminUserController::class, 'update'])->name('users.update');
    
            // Societies
            Route::get('/societies',                [AdminSocietyController::class, 'index'])->name('societies.index');
            Route::get('/societies/{society}/edit', [AdminSocietyController::class, 'edit'])->name('societies.edit');
            Route::put('/societies/{society}',      [AdminSocietyController::class, 'update'])->name('societies.update');
            Route::delete('/societies/{society}',   [AdminSocietyController::class, 'destroy'])->name('societies.destroy');
    
            // Assign / change the "admin pro" (role_id = 2) for a society
            Route::post('/societies/{society}/assign-admin-pro', [AdminSocietyController::class, 'assignAdminPro'])->name('societies.assignAdminPro');
    
            // Users admin import CSV
            Route::get('/users/import',  [AdminUserController::class, 'importForm'])->name('users.import.form');
            Route::post('/users/import', [AdminUserController::class, 'importCsv'])->name('users.import.csv');
    
    
            // Itineraries management (global admin)
            Route::get   ('/itineraries',                    [ItineraryController::class,'index'])->name('itins.index');
            Route::get   ('/itineraries/create',             [ItineraryController::class,'create'])->name('itins.create');
            Route::post  ('/itineraries',                    [ItineraryController::class,'store'])->name('itins.store');
            Route::get   ('/itineraries/{itinerary}/edit',   [ItineraryController::class,'edit'])->whereNumber('itinerary')->name('itins.edit');
            Route::put   ('/itineraries/{itinerary}',        [ItineraryController::class,'update'])->whereNumber('itinerary')->name('itins.update');
            Route::delete('/itineraries/{itinerary}',        [ItineraryController::class,'destroy'])->whereNumber('itinerary')->name('itins.destroy');
            Route::get   ('/itineraries/{itinerary}/map',    [ItineraryController::class,'map'])->whereNumber('itinerary')->name('itins.map');
            Route::post  ('/itineraries/{itinerary}/validate', [ItineraryController::class, 'validateItinerary'])->name('itins.validate');
            // AJAX helpers (admin)
            Route::get('/itineraries/admins-for-society',  [ItineraryController::class,'adminsForSociety'])->name('itins.adminsForSociety');
            Route::get('/itineraries/users-for-society',   [ItineraryController::class,'usersForSociety'])->name('itins.usersForSociety');
            Route::get('/itineraries/points-for-context',  [ItineraryController::class,'pointsForContext'])->name('itins.pointsForContext');
                
            Route::post('/itineraries/{itinerary}/progress',[ItineraryController::class, 'saveProgress'])->name('itins.progress.save');
        
     

        });
    
    
        // ------------------------------------------------------------
        // 3.5) admin pro area
        // ------------------------------------------------------------
    
        // --- PRO (role_id=2) : LOCALISÉ ---
        Route::group([
            'prefix' => 'pro',
            'as' => 'pro.',
            'middleware' => ['auth', \App\Http\Middleware\EnsureAdminPro::class],
        ], function () {
            Route::get('/users',            [ProUserController::class, 'index'])->name('users.index');
            Route::get('/users/create',     [ProUserController::class, 'create'])->name('users.create');
            Route::post('/users',           [ProUserController::class, 'store'])->name('users.store');
            Route::get('/users/{user}/edit',[ProUserController::class, 'edit'])->name('users.edit');
            Route::put('/users/{user}',     [ProUserController::class, 'update'])->name('users.update');
            Route::delete('/users/{user}',  [ProUserController::class, 'destroy'])->name('users.destroy');
    
            Route::get('/users/import',     [ProUserController::class, 'importForm'])->name('users.import.form');
            Route::post('/users/import',    [ProUserController::class, 'importCsv'])->name('users.import.csv');
    
            // Itineraries management (pro admin)
            Route::get   ('/itineraries',                  [ItineraryController::class,'index'])->name('itins.index');
            Route::get   ('/itineraries/create',           [ItineraryController::class,'create'])->name('itins.create');
            Route::post  ('/itineraries',                  [ItineraryController::class,'store'])->name('itins.store');
            Route::get   ('/itineraries/{itinerary}/edit', [ItineraryController::class,'edit'])->whereNumber('itinerary')->name('itins.edit');
            Route::put   ('/itineraries/{itinerary}',      [ItineraryController::class,'update'])->whereNumber('itinerary')->name('itins.update');
            Route::delete('/itineraries/{itinerary}',      [ItineraryController::class,'destroy'])->whereNumber('itinerary')->name('itins.destroy');
            Route::get   ('/itineraries/{itinerary}/map',  [ItineraryController::class,'map'])->whereNumber('itinerary')->name('itins.map');
        
            // AJAX helpers (pro) — same handlers
            Route::get('/itineraries/admins-for-society',  [ItineraryController::class,'adminsForSociety'])->name('itins.adminsForSociety');
            Route::get('/itineraries/users-for-society',   [ItineraryController::class,'usersForSociety'])->name('itins.usersForSociety');
            Route::get('/itineraries/points-for-context',  [ItineraryController::class,'pointsForContext'])->name('itins.pointsForContext');
            Route::post('/itineraries/{itinerary}/progress',[ItineraryController::class, 'saveProgress'])->name('itins.progress.save');
            Route::post  ('/itineraries/{itinerary}/validate', [ItineraryController::class, 'validateItinerary'])->name('itins.validate');
       
            // Waypoints (owned by the company or shared to its admins)
            Route::get('/points', [ProPointController::class, 'index'])->name('points.index');
    
            // Company detail (the company the admin pro belongs to)
            Route::get('/society', [ProSocietyController::class, 'edit'])->name('society.edit'); 
            Route::put('/society', [ProSocietyController::class, 'update'])->name('society.update'); // save
          
    
        });
    
      
});





// ------------------------------------------------------------
// 2) Non-localized helpers / fallbacks
// ------------------------------------------------------------

// Short URL for QR codes: /wx/{token} -> redirect to localized page
Route::get('/wx/{token}', function (string $token) {
    $point = Point::where('serial', $token)->firstOrFail();

    $locale = app()->getLocale() ?: 'fr';

    return redirect()->route('points.public.readonly', [
        'locale' => $locale,
        'token'  => $point->serial,
    ]);
})->where('token', '[A-Za-z0-9\-\_=]+')->name('points.wx');





    Route::get('/w/{token}', function (string $token, Request $request) {
        // Récupère les locales supportées depuis config/locales.php
        $supported = array_keys(config('locales.supported', ['fr' => [], 'en' => []]));
        $default   = config('locales.default', 'fr');

        // Choix de la locale :
        // 1. Session
        // 2. Langue préférée du navigateur (parmi celles supportées)
        // 3. Locale par défaut
        $locale = session('locale')
            ?? $request->getPreferredLanguage($supported)
            ?? $default;

        // Clamp de sécurité : si la locale n’est pas dans la liste → fallback
        if (! in_array($locale, $supported, true)) {
            $locale = $default;
        }

        // Redirection vers la page publique localisée
        return redirect()->route('points.public.readonly', [
            'locale' => $locale,
            'token'  => $token,
        ]);
    })
    ->where('token', '[A-Za-z0-9\-\_=]+')
    ->name('points.public.readonly.global');



// Public reporting endpoint (global, not localized)
Route::post('/reporting', [ReportingController::class, 'store'])
    ->name('reporting.store')
    ->middleware('throttle:5,1'); // 5 requests/min per IP

Route::put('/reporting/{report}/resolve', [ReportingController::class, 'resolve'])
     ->whereNumber('report')
    ->name('reporting.resolve'); // 5 requests/min per IP



Route::post('/logout', function (Request $request) {
    Auth::guard('web')->logout();
    $request->session()->invalidate();
    $request->session()->regenerateToken();

    $locale = $request->input('locale', session('locale', app()->getLocale() ?: 'fr'));
    return redirect('/'.$locale);
})->name('logout.fallback');

// Email verification notice

Route::get('/email/verify/{id}/{hash}', function (Request $request, $id, $hash) {
    // 1) Lien signé valide ?
    if (! URL::hasValidSignature($request)) {
        abort(403, 'Invalid or expired signature');
    }

    // 2) Récupérer l’utilisateur
    $user = \App\Models\User::findOrFail($id);

    // 3) Vérifier le hash (comme Laravel le fait)
    if (! hash_equals(sha1($user->getEmailForVerification()), (string) $hash)) {
        abort(403, 'Invalid verification hash');
    }

    // 4) Déjà vérifié ?
    if ($user->hasVerifiedEmail()) {
        // Optionnel: connecter l’utilisateur pour le confort
        Auth::login($user);
        return redirect()->route('search', ['locale' => session('locale', app()->getLocale())])
            ->with('ok', __('Email already verified.'));
    }

    // 5) Marquer comme vérifié
    $user->markEmailAsVerified();
    event(new Verified($user));

    // Optionnel : connecter l’utilisateur après vérification
    Auth::login($user);

    // 6) Rediriger vers une page locale qui existe chez toi
    $locale = session('locale', app()->getLocale() ?: 'fr');
    return redirect()->route('search', ['locale' => $locale])
        ->with('ok', __('Your email has been verified.'));
})->name('verification.verify'); // un nom distinct pour ne rien casser   




// Useful non-localized fallbacks (redirect to the current locale)
Route::get('/login', function () {
    return redirect()->route('login', ['locale' => session('locale', app()->getLocale())]);
})->name('login.redirect');

Route::get('/register', function () {
    return redirect()->route('register', ['locale' => session('locale', app()->getLocale())]);
})->name('register.redirect');




    


// ------------------------------------------------------------
// 4) Dev/test-only routes (lock down!)
// ------------------------------------------------------------
if (app()->environment('local')) {
    Route::get('/test-mail', function () {
        Mail::to('raph@mac.com')->send(new TestBrevoMail('Hello depuis Brevo 👋'));
        return 'Mail sent!';
    });

    Route::get('/mail-debug', function () {
        return [
            'mailer'     => config('mail.default'),
            'host'       => config('mail.mailers.smtp.host'),
            'port'       => config('mail.mailers.smtp.port'),
            'encryption' => config('mail.mailers.smtp.encryption'),
            'username'   => config('mail.mailers.smtp.username'),
            'from'       => config('mail.from.address'),
        ];
    });
}

// ------------------------------------------------------------
// Reporting admin area (non-localized for now)
// ------------------------------------------------------------



// --- Admin Reporting management ---
Route::prefix('admin/reporting')->middleware(['auth'])->group(function () {
    // List unresolved reports
    Route::get('/', [ReportingAdminController::class, 'index'])->name('admin.reporting.index');
    // Show one report detail
    Route::get('/{report}', [ReportingAdminController::class, 'show'])->whereNumber('report')->name('admin.reporting.show');
    // Resolve one report
    Route::put('/{report}/resolve', [ReportingAdminController::class, 'resolve'])->whereNumber('report')->name('admin.reporting.resolve');
});


// ------------------------------------------------------------
// 5) Password reset routes
// ------------------------------------------------------------ 
Route::get('password/reset', [ForgotPasswordController::class, 'showLinkRequestForm'])
    ->name('password.request');
Route::post('password/email', [ForgotPasswordController::class, 'sendResetLinkEmail'])
    ->name('password.email');
Route::get('password/reset/{token}', [ResetPasswordController::class, 'showResetForm'])
    ->name('password.reset');
Route::post('password/reset', [ResetPasswordController::class, 'reset'])
    ->name('password.update');





require __DIR__.'/auth.php';
