<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_','-',app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width,initial-scale=1">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
        <title><?php echo $__env->yieldContent('title', config('app.name','Laravel')); ?></title>
        <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css','resources/js/app.js']); ?>

        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Barlow:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">
 
         <link rel="stylesheet" href="/assets/css/global.css">
        <link rel="stylesheet" href="/assets/css/vereego.css">

   </head>
    <?php echo $__env->yieldPushContent('scripts'); ?>
    <body class="antialiased">
        <header class="nav">
            <div class="wrap nav-row" style="display:flex;align-items:center;justify-content:space-between;gap:12px;">
                
                <a class="brand" href="<?php echo e(lr('welcome')); ?>" style="display:inline-flex;align-items:center;gap:8px">
                    <img src="/assets/images/Logo_Vereego_500.png" alt="Vereego" style="height:38px;width:auto">
                    <span></span>
                </a>

                
                <?php
                    $onHome   = request()->routeIs('welcome');
                    $onMap    = request()->routeIs('map');
                    $onSearch = request()->routeIs('search');
                ?>


            <?php if (! ($onHome)): ?>
                    <a class="btn small ghost"  href="<?php echo e(lr('welcome')); ?>" style="display:inline-flex;align-items:center;gap:8px">
                        <?php echo e(__('Home')); ?>

                    </a>
                <?php endif; ?>

    
                
                <nav class="nav-left" style="display:flex;gap:8px;align-items:center">
                    <?php echo $__env->yieldPushContent('nav.left'); ?>  
                </nav>

                <nav style="display:flex;gap:12px;align-items:center">
    
                    
                    <?php echo $__env->yieldPushContent('nav.right'); ?>



                    
                    
                    
                    
                    <?php if(auth()->guard()->check()): ?>
                        
   
                        
 
                        <?php
                            // to avoid a heavy query everywhere, we test "exists()" when we can
                            $hasItins = optional(auth()->user()->itinerariesAssigned()->limit(1)->pluck('itineraries.id'))->isNotEmpty();
                        ?>
 
                        <div class="dropdown admin-dropdown">
                            <button class="btn small ghost dropdown-toggle" type="button" aria-haspopup="true" aria-expanded="false">
                                <?php echo e(__('Waypoints')); ?> ▾
                            </button>
                            <div class="dropdown-menu" role="menu" style="position:absolute;right:0;top:100%;margin-top:6px;min-width:200px;background:#fff;border:1px solid #1f2430;border-radius:10px;padding:8px;z-index:900">
                                <?php if (! ($onMap)): ?>
                                    <a style="margin:6px 0 0; width: 100%;" class="btn small primary" href="<?php echo e(lr('map')); ?>"><?php echo e(__('New waypoint')); ?></a>
                                <?php endif; ?>
                                <?php if (! ($onSearch)): ?>
                                    <a style="margin:6px 0 0; width: 100%;" class="btn small ghost" href="<?php echo e(lr('search')); ?>"><?php echo e(__('My waypoints')); ?></a>
                                <?php endif; ?>
                                <?php if($hasItins): ?>
                                    <a style="margin:6px 0 0; width: 100%;" class="btn small ghost" href="<?php echo e(route('itins.mine', ['locale'=>app()->getLocale()])); ?>" class="<?php echo e(request()->routeIs('itins.mine') ? 'active' : ''); ?>">
                                        <?php echo e(__('Itineraries')); ?>

                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>

   

                        <?php
                            $u = Auth::user();
                            $isSuper = $u && (((int)($u->role_id ?? 0) === 1) || strcasecmp(optional($u->role)->name ?? '', 'Admin') === 0);
                        ?>
                        <?php if($isSuper && Route::has('admin.points.index')): ?>
                            <div class="dropdown admin-dropdown">
                                <button class="btn small ghost dropdown-toggle" type="button" aria-haspopup="true" aria-expanded="false">
                                    <?php echo e(__('Admin')); ?> ▾
                                </button>
                                <div class="dropdown-menu" role="menu" style="position:absolute;right:0;top:100%;margin-top:6px;min-width:200px;background:#fff;border:1px solid #1f2430;border-radius:10px;padding:8px;z-index:900">
                                    <a class="dropdown-item btn small ghost" href="<?php echo e(route('admin.points.index')); ?>">
                                        <?php echo e(__('Waypoints')); ?>

                                    </a>
                                    <a class="dropdown-item btn small ghost" href="<?php echo e(route('admin.users.index')); ?>">
                                        <?php echo e(__('Users')); ?>

                                    </a>
                                    <a class="dropdown-item btn small ghost" href="<?php echo e(route('admin.societies.index')); ?>">
                                        <?php echo e(__('Societies')); ?>

                                    </a>
                                    <a class="dropdown-item btn small ghost" href="<?php echo e(route((auth()->id()===1?'admin':'pro').'.itins.index')); ?>">
                                        <?php echo e(__('Itineraries')); ?>

                                    </a>
                                <a class="dropdown-item btn small ghost" href="<?php echo e(route((auth()->id()===1?'admin':'pro').'.reporting.index')); ?>">
                                        <?php echo e(__('Reporting')); ?>

                                    </a>
                                </div>
                            </div>

                        <?php endif; ?>



                        
                        
                        
                        
                        <?php if(auth()->guard()->check()): ?>
                            <?php $isAdminPro = (int)(auth()->user()->role_id ?? 0) === 2; ?>
                            <?php if($isAdminPro): ?>
                                <div class="dropdown admin-dropdown">
                                    <button class="btn small ghost dropdown-toggle" type="button" aria-haspopup="true" aria-expanded="false">
                                        <?php echo e(__('Admin Pro')); ?> ▾
                                    </button>
                                    <div class="dropdown-menu" role="menu" style="position:absolute;right:0;top:100%;margin-top:6px;min-width:200px;background:#fff;border:1px solid #1f2430;border-radius:10px;padding:8px;z-index:900">
                                        <a class="dropdown-item btn small ghost" href="<?php echo e(route('pro.points.index')); ?>">
                                            <?php echo e(__('Waypoints')); ?>

                                        </a>
                                        <a class="dropdown-item btn small ghost" href="<?php echo e(route('pro.users.index')); ?>">
                                            <?php echo e(__('Users')); ?>

                                        </a>
                                        <a class="dropdown-item btn small ghost" href="<?php echo e(route('pro.society.edit', ['locale'=>app()->getLocale()])); ?>">
                                            <?php echo e(__('Society')); ?>

                                        </a>
                                        <a class="dropdown-item btn small ghost" href="<?php echo e(route((auth()->id()===1?'admin':'pro').'.itins.index')); ?>">
                                            <?php echo e(__('Itineraries')); ?>

                                        </a> 
                                    </div>
                                </div>
                            <?php endif; ?>
                        <?php endif; ?>



                        
                        <div class="dropdown" style="float:right; position:relative">
                           <button type="button" class="btn small ghost" id="user-menu-btn" aria-haspopup="true" aria-expanded="false" style="display:inline-flex;align-items:center;gap:6px">

                                <?php $avatar = $u->photo ? Storage::url($u->photo) : '/assets/images/logo_128.png'; ?>    
    
                                <img src="<?php echo e($avatar); ?>" alt="avatar" height="18" width="18" style="border-radius:999px;object-fit:cover;border:1px solid #e5e7eb">

                                <span style="font-weight:600"><?php echo e($u->firstname ?? $u->name ?? 'Compte'); ?> ▾</span>
                            </button>
                            <div id="user-menu" class="card dropdown-menu" style="display:none;position:absolute;right:0;top:100%;margin-top:6px;min-width:200px;background:#fff;border:1px solid #1f2430;border-radius:10px;padding:8px;z-index:900">
                                <a class="btn small ghost" href="<?php echo e(lr('user.edit')); ?>" style="width:100%;text-align:left"><?php echo e(__('My informations')); ?></a>
    
                                <form id="logout-form" method="POST" action="<?php echo e(route('logout', ['locale'=>app()->getLocale()])); ?>" style="display:none;">
                                    <?php echo csrf_field(); ?>
                                </form>

                                <a class="btn small danger" style="margin:6px 0 0; width: 100%;" href="#" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                                    <?php echo e(__('Log out')); ?>

                                </a>
                            </div>
 
                        </div>
                    <?php else: ?>

                        <?php if(auth()->guard()->guest()): ?>
                            
                            
                            
                            <div class="dropdown" style="float:right; position:relative">
                                <button type="button" class="btn small ghost" id="user-menu-btn" aria-haspopup="true" aria-expanded="false" style="display:inline-flex;align-items:center;gap:6px">
                        
                                    <img src="/assets/images/logo_128.png" alt="avatar" height="18" width="18" style="border-radius:999px;object-fit:cover;border:1px solid #e5e7eb">

                                    <span style="font-weight:600"><?php echo e($u->firstname ?? $u->name ?? 'Compte'); ?> ▾</span>
                                </button>
                                <div id="user-menu" class="card dropdown-menu" style="">
                                    <a class="btn small danger" style="width:100%;text-align:left" href="<?php echo e(lr('login')); ?>"><?php echo e(__('Log in')); ?></a>
                                    <a class="btn small ghost" style="width:100%;text-align:left; margin-top:6px;" href="<?php echo e(lr('register')); ?>"><?php echo e(__('Create account')); ?></a>
                                </div>
                            </div>
                        <?php else: ?>
                            <form method="POST" action="<?php echo e(route('logout', ['locale' => app()->getLocale()])); ?>" style="display:inline">
                                <?php echo csrf_field(); ?>
                                <button class="btn small ghost" type="submit"><?php echo e(__('Log out')); ?></button>
                            </form>
                        <?php endif; ?>
                    <?php endif; ?>




                    
 
                    <?php
                        $current = app()->getLocale();
                        $locales = config('locales.supported'); // si pas de View::share
                    ?>

                     <div class="dropdown lang-dropdown" style="position:relative">
                        
                        <button type="button"
                                class="btn small ghost dropdown-toggle"
                                id="lang-menu-btn"
                                aria-haspopup="true"
                                aria-expanded="false"
                                style="display:inline-flex;align-items:center;gap:6px;">
                            <?php echo e($locales[$current]['flag'] ?? ''); ?> <?php echo e(strtoupper($current)); ?> ▾
                        </button>
                         <div id="lang-menu"
                            class="card dropdown-menu"
                            style="display:none;position:absolute;right:0;top:100%;margin-top:6px;min-width:140px;background:#fff;border:1px solid #1f2430;border-radius:10px;padding:8px;z-index:900">
                            
                            <?php $__currentLoopData = $locales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $code => $meta): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($code === $current) continue; ?>
                                <a href="<?php echo e(url('/'.$code)); ?>">
                                    <span class="btn small ghost" style="width: 100%;"><?php echo e($meta['flag'] ?? ''); ?> <?php echo e($meta['label']); ?></span><br>
                                </a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>


                </nav>
            </div>
        </header>

        <main>
            <?php echo $__env->yieldContent('content'); ?>
        </main>



        
        <?php if(!request()->cookies->has('cookie_consent')): ?>
            <div id="cookie-banner" style="
                position: fixed;
                bottom: 0;
                left: 0;
                right: 0;
                background: rgba(15,15,15,0.95);
                color: #fff;
                padding: 16px 20px;
                font-size: 14px;
                z-index: 10000;
                display: flex;
                flex-wrap: wrap;
                align-items: center;
                justify-content: space-between;
            ">
            <div style="flex:1 1 auto; max-width: 750px; line-height:1.5;">
                <?php echo e(__('We use cookies to improve your browsing experience and analyze site traffic. By continuing, you agree to our use of cookies. You can withdraw your consent at any time in your browser settings.')); ?>

            </div>

            <div style="flex: 0 0 auto; display:flex; gap:10px; margin-left:20px;">
                <button id="accept-cookies" class="btn primary" style="background:#3a6cff; border:none; color:white; padding:6px 14px; border-radius:6px;">
                <?php echo e(__('Accept')); ?>

                </button>
                <button id="decline-cookies" class="btn ghost" style="background:none; border:1px solid #aaa; color:#ddd; padding:6px 14px; border-radius:6px;">
                <?php echo e(__('Refuse')); ?>

                </button>
            </div>
            </div>

            <script>
                document.addEventListener('DOMContentLoaded', () => {
                    const acceptBtn = document.getElementById('accept-cookies');
                    const declineBtn = document.getElementById('decline-cookies');
                    const banner = document.getElementById('cookie-banner');

                    function setConsent(value) {
                        const expires = new Date();
                        expires.setFullYear(expires.getFullYear() + 1);
                        document.cookie = "cookie_consent=" + value + "; path=/; expires=" + expires.toUTCString() + "; SameSite=Lax";
                        banner.style.display = 'none';
                    }

                    acceptBtn.addEventListener('click', () => setConsent('accepted'));
                    declineBtn.addEventListener('click', () => setConsent('declined'));
                });
            </script>
        <?php endif; ?>


        <script>
            document.addEventListener('click', (e) => {
                const dropdowns = [
                    { btn: document.getElementById('user-menu-btn'), menu: document.getElementById('user-menu') },
                    { btn: document.getElementById('lang-menu-btn'), menu: document.getElementById('lang-menu') },
                ];

                dropdowns.forEach(({ btn, menu }) => {
                    if (!btn || !menu) {
                        return;
                    }

                    const clickedToggle = btn.contains(e.target);
                    const clickedInside = menu.contains(e.target);

                    if (clickedToggle) {
                        e.preventDefault();
                        const isOpen = menu.style.display === 'block';
                        menu.style.display = isOpen ? 'none' : 'block';
                        btn.setAttribute('aria-expanded', (!isOpen).toString());
                    } else if (!clickedInside) {
                        menu.style.display = 'none';
                        btn.setAttribute('aria-expanded', 'false');
                    }
                });
            });

            document.addEventListener('click', (e) => {
                // Ferme tous les dropdowns si clic à l'extérieur
                document.querySelectorAll('.dropdown.open').forEach(d => {
                    if (!d.contains(e.target)) d.classList.remove('open');
                });

                const toggle = e.target.closest('.dropdown-toggle');
                if (toggle && toggle.closest('.dropdown')) {
                    const dd = toggle.closest('.dropdown');
                    dd.classList.toggle('open');
                }
            });

        </script>

    </body>
</html>
<?php /**PATH /home/raph/Sites/vereego/resources/views/layouts/base.blade.php ENDPATH**/ ?>