<?php $__env->startSection('title', 'VereeGo'); ?>

<?php $__env->startPush('nav.left'); ?>
  <a href="#qui" class="btn small ghost"><?php echo e(__('Qui sommes-nous')); ?></a>
  <a href="#comment" class="btn small ghost"><?php echo e(__('Concept')); ?></a>
  <a href="#contact" class="btn small ghost"><?php echo e(__('Contact')); ?></a>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>


<?php
    $img = [
        'logo'          => '/assets/images/Logo_Vereego_500.png',
        'hero_phone'    => '/assets/wp/flying-iphone-12-vereego-3.png',
        'how_map'       => '/assets/images/Simulator-3.png',
        'round_bg'      => '/assets/images/round_bg.png',
        'easy'          => '/assets/images/easy-to-manage-icon.png',
        'top'           => '/assets/images/top_rose.svg',
        'form_mock'     => '/assets/images/screencap-1.png',
        'card_mock'     => '/assets/images/screencap--3.png',
        'appstore'      => '/assets/wp/app-store-img-footer-1.png',
        'playstore'     => '/assets/wp/google-play-img-footer-1.png',
        'icon_protect'  => '/assets/wp/features-icon-1-1.png',
        'icon_innov'    => '/assets/wp/features-icon-2-1.png',
        'icon_vision'   => '/assets/wp/features-icon-3-1.png',
        'icon_dl'       => '/assets/wp/features-icon-4-1.png',
        'icon_qr'       => '/assets/wp/features-icon-5-1.png',
        'icon_share'    => '/assets/wp/features-icon-6-1.png',
    ];
?>

<link rel="stylesheet" href="/assets/css/global.css">
<link rel="stylesheet" href="/assets/css/vereego.css">
<link rel="stylesheet" href="/assets/css/float.css">


<script src="https://cdn.jsdelivr.net/npm/request-tick@1.0.1/lib/index.min.js"></script>

<a class="btn top_btn" href="#top">
    <img class="top" id="floatingTopImage" src="<?php echo e($img['top']); ?>" alt="Top">
</a>



<section class="hero container_float full-height" id="top">
  <div class="wrap">
    <div class="grid-2">
      <div>
        <h1><?php echo e(__('hero_title')); ?></h1>
        <p><?php echo e(__('hero_subtitle')); ?></p>
        <a href="#appstore" class="btn small ghost"><?php echo e(__('download_app')); ?></a>
      </div>
      <div class="center">
        <img class="phone floating-image" id="floatingImage" src="<?php echo e($img['hero_phone']); ?>" alt="<?php echo e(__('app_image_alt')); ?>">
      </div>
    </div>
  </div>
</section>


<section id="qui" class="section overlay-div">
  <div class="wrap">
    <h2 class="center title"><?php echo e(__('about_title')); ?></h2>
    <p class="center" style="max-width:800px;margin:8px auto 28px;line-height:1.9em;">
      <?php echo nl2br(e(__('about_text'))); ?>

    </p>
    <div class="grid-3">
      <div class="card">
        <div class="step">
          <img src="<?php echo e($img['icon_protect']); ?>" alt="">
          <div>
            <h3 style="color:var(--blue)"><?php echo e(__('about_precision_title')); ?></h3>
            <p><?php echo e(__('about_precision_text')); ?></p>
          </div>
        </div>
      </div>
      <div class="card">
        <div class="step">
          <img src="<?php echo e($img['icon_innov']); ?>" alt="">
          <div>
            <h3 style="color:var(--blue)"><?php echo e(__('about_innovation_title')); ?></h3>
            <p><?php echo e(__('about_innovation_text')); ?></p>
          </div>
        </div>
      </div>
      <div class="card">
        <div class="step">
          <img src="<?php echo e($img['icon_vision']); ?>" alt="">
          <div>
            <h3 style="color:var(--blue)"><?php echo e(__('about_vision_title')); ?></h3>
            <p><?php echo e(__('about_vision_text')); ?></p>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>


<section id="comment" class="section overlay-div full-height" style="background:#fff">
  <div class="wrap grid-2">
    <div>
      <h2 class="title"><?php echo e(__('how_title')); ?></h2>

      <div class="walk_bloc">
        <span class="circle">
            <svg xmlns="http://www.w3.org/2000/svg" width="50" height="50" viewBox="0 0 50 50"><defs><style>.cls-1{fill:#bd32d3;fill-rule:evenodd}</style></defs><path id="make-a-profile-icon" class="cls-1" d="M449.507,1937.99H419.5a2.5,2.5,0,0,0-2.5,2.5v18.34H406.16a2.5,2.5,0,0,0-2.5,2.5V1978h-0.833a0.839,0.839,0,0,0-.834.84,4.18,4.18,0,0,0,4.168,4.17h26.675a4.165,4.165,0,0,0,4.168-4.16v-0.01a0.839,0.839,0,0,0-.833-0.84h-0.834v-9.16h9.17a0.839,0.839,0,0,0,.833-0.84,0.831,0.831,0,0,0-.833-0.83h-4.373l-1.191-4.17h10.565a2.5,2.5,0,0,0,2.5-2.5v-20.01A2.5,2.5,0,0,0,449.507,1937.99Zm-44.181,23.34a0.831,0.831,0,0,1,.834-0.83h26.675a0.831,0.831,0,0,1,.834.83V1978H422a0.839,0.839,0,0,0-.833.84H417.83A0.839,0.839,0,0,0,417,1978H405.326v-16.67Zm29.283,19.27a2.517,2.517,0,0,1-1.774.74H406.16a2.5,2.5,0,0,1-2.358-1.67h12.361a0.839,0.839,0,0,0,.834.84h5a0.839,0.839,0,0,0,.834-0.84h12.361A2.484,2.484,0,0,1,434.609,1980.6Zm0.727-13.43V1963h1.872l1.191,4.17h-3.063Zm15-6.67a0.831,0.831,0,0,1-.834.83H435.336a2.5,2.5,0,0,0-2.5-2.5H418.664v-18.34a0.831,0.831,0,0,1,.834-0.83h30.009a0.831,0.831,0,0,1,.834.83v20.01Zm-2.5,9.17h-6.669a2.5,2.5,0,0,0-2.5,2.5v13.34a2.5,2.5,0,0,0,2.5,2.5h6.669a2.5,2.5,0,0,0,2.5-2.5v-13.34A2.5,2.5,0,0,0,447.84,1969.67Zm0.834,15.84a0.831,0.831,0,0,1-.834.83h-6.669a0.831,0.831,0,0,1-.833-0.83v-13.34a0.831,0.831,0,0,1,.833-0.83h6.669a0.831,0.831,0,0,1,.834.83v13.34Z" transform="translate(-402 -1938)"></path></svg>
        </span>
        <div class="walk_txt">
          <h3><span style="color:var(--blue)"><?php echo e(__('how_step1_title')); ?></span></h3>
          <p><?php echo e(__('how_step1_text')); ?></p>
        </div>
      </div>

      <div class="walk_bloc">
        <span class="circle">
            <svg xmlns="http://www.w3.org/2000/svg" width="57.094" height="50" viewBox="0 0 57.094 50"><defs><style>.cls-1{fill:#bd32d3;fill-rule:evenodd}</style></defs><path id="download-it-icon" class="cls-1" d="M416.208,2172.63a13.294,13.294,0,0,1,17.262,4.64,1.332,1.332,0,0,0,1.525.55,8.371,8.371,0,0,1,10.845,7.06,1.336,1.336,0,0,0,.934,1.13,9.24,9.24,0,0,1,6.486,7.76,0.841,0.841,0,0,0,.83.74,0.334,0.334,0,0,0,.1-0.01,0.836,0.836,0,0,0,.734-0.93,10.905,10.905,0,0,0-7.444-9.09,10.059,10.059,0,0,0-12.743-8.33,14.919,14.919,0,0,0-12.459-6.66,14.732,14.732,0,0,0-6.834,1.65,0.837,0.837,0,0,0,.765,1.49h0Zm37.864,23.8a0.835,0.835,0,0,0-1.013.61,9.277,9.277,0,0,1-3.283,5.05,9.434,9.434,0,0,1-5.817,2.01h-9.006a0.835,0.835,0,1,0,0,1.67h9.006a11.174,11.174,0,0,0,6.851-2.36,10.972,10.972,0,0,0,3.875-5.97A0.833,0.833,0,0,0,454.072,2196.43Zm-35.246,8.51a0.835,0.835,0,0,0-.837-0.84h-7.533a10.925,10.925,0,0,1-7.79-3.26,10.637,10.637,0,0,1-3.14-7.6,10.807,10.807,0,0,1,8.69-10.5,1.34,1.34,0,0,0,1.044-1.03,13.233,13.233,0,0,1,4.156-7.17,0.834,0.834,0,1,0-1.116-1.24,14.848,14.848,0,0,0-4.631,7.84,12.492,12.492,0,0,0-9.818,12.09,12.3,12.3,0,0,0,3.627,8.79,12.578,12.578,0,0,0,8.978,3.75h7.533A0.833,0.833,0,0,0,418.826,2204.94Zm18.089,4.28h-4.474v-11.47a1.805,1.805,0,0,0-1.8-1.8H422.3a1.805,1.805,0,0,0-1.8,1.8v4.69a0.838,0.838,0,0,0,1.675,0v-4.69a0.13,0.13,0,0,1,.127-0.13h8.336a0.13,0.13,0,0,1,.127.13v12.31a0.832,0.832,0,0,0,.837.83h4.227l-9.2,6.89a0.251,0.251,0,0,1-.326,0l-9.2-6.89h4.227a0.833,0.833,0,0,0,.837-0.83V2206a0.838,0.838,0,0,0-1.675,0v3.22h-4.474a1.311,1.311,0,0,0-.788,2.36l10.064,7.54a1.944,1.944,0,0,0,2.336,0l10.064-7.54a1.311,1.311,0,0,0-.788-2.36h0Zm-15.907-17.45a0.841,0.841,0,0,0,.838.84h9.25a0.841,0.841,0,0,0,.837-0.84,0.832,0.832,0,0,0-.837-0.83h-9.25a0.833,0.833,0,0,0-.838.83h0Zm1.6-5.01a0.841,0.841,0,0,0,.838.84H429.5a0.84,0.84,0,0,0,0-1.68h-6.054a0.841,0.841,0,0,0-.838.84h0Zm5.827-4.18a0.835,0.835,0,1,0,0-1.67h-3.924a0.835,0.835,0,1,0,0,1.67h3.924Z" transform="translate(-397.844 -2169.5)"></path></svg>
        </span>
        <div class="walk_txt">
          <h3><span style="color:var(--blue)"><?php echo e(__('how_step2_title')); ?></span></h3>
          <p><?php echo e(__('how_step2_text')); ?></p>
        </div>
      </div>

      <div class="walk_bloc">
        <span class="circle">
            <svg xmlns="http://www.w3.org/2000/svg" width="58.876" height="50" viewBox="0 0 58.876 50"><defs><style>.cls-1{fill:#bd32d3;fill-rule:evenodd}</style></defs><path id="enjoy-this-app-icon" class="cls-1" d="M424.987,2438.44l-3.517-3.35a0.862,0.862,0,1,1,1.187-1.25l2.772,2.64,5.009-7.57a0.862,0.862,0,0,1,1.438.95s-5.573,8.42-5.576,8.43A0.881,0.881,0,0,1,424.987,2438.44Zm0.578,12.79c-12.8-5.98-15.138-18.99-15.542-22.85a2.035,2.035,0,0,1,1.22-2.09,7.293,7.293,0,0,0,4.419-6.17,1.66,1.66,0,0,1,1.659-1.55l17.166-.1h0.01a1.675,1.675,0,0,1,1.667,1.52,7.3,7.3,0,0,0,4.484,6.13,2.028,2.028,0,0,1,1.251,2.07c-0.359,3.87-2.545,16.91-15.273,23.04A1.393,1.393,0,0,1,425.565,2451.23Zm-8.187-30.94a9.016,9.016,0,0,1-5.457,7.59,0.307,0.307,0,0,0-.182.32c0.377,3.61,2.527,15.79,14.347,21.37,11.753-5.72,13.76-17.92,14.095-21.54a0.317,0.317,0,0,0-.194-0.32,9.022,9.022,0,0,1-5.537-7.52Zm8.015,27.4a22.459,22.459,0,0,1-9.112-9.18,28.027,28.027,0,0,1-2.945-8.73,1.427,1.427,0,0,1,.673-1.46,9.435,9.435,0,0,0,4.228-5.56,1.429,1.429,0,0,1,1.372-1.05l12.627-.08a1.44,1.44,0,0,1,1.384,1.04,9.456,9.456,0,0,0,4.293,5.51,1.43,1.43,0,0,1,.69,1.45,28.14,28.14,0,0,1-2.843,8.77,22.5,22.5,0,0,1-9,9.28A1.4,1.4,0,0,1,425.393,2447.69Zm-10.322-18a26.292,26.292,0,0,0,2.727,8,20.431,20.431,0,0,0,8.267,8.4,20.484,20.484,0,0,0,8.169-8.49,26.418,26.418,0,0,0,2.633-8.03,11.15,11.15,0,0,1-4.84-6.21l-12.19.07A11.108,11.108,0,0,1,415.071,2429.69Zm30.918,10.07h-4.074a0.86,0.86,0,1,1,0-1.72h4.074a7.735,7.735,0,0,0,0-15.47c-0.985.01-1.071-.64-1.08-2.01a17.532,17.532,0,0,0-17.466-17.48,17.726,17.726,0,0,0-16.226,11,1.163,1.163,0,0,1-1.228.53,11.715,11.715,0,0,0,0,23.43,0.86,0.86,0,1,1,0,1.72,13.44,13.44,0,0,1-.143-26.88c4.136-9.95,13.684-11.53,17.6-11.53a19.224,19.224,0,0,1,19.191,19.21c0,0.1,0,.2,0,0.31A9.456,9.456,0,0,1,445.989,2439.76Z" transform="translate(-396.562 -2401.34)"></path></svg>
        </span>
        <div class="walk_txt">
          <h3><span style="color:var(--blue)"><?php echo e(__('how_step3_title')); ?></span></h3>
          <p><?php echo e(__('how_step3_text')); ?></p>
        </div>
      </div>

      <div class="grid-2">
        <div>
          <a href="https://apps.apple.com/us/app/vereego/id6479544906" target="_blank" rel="noopener">
            <img loading="lazy" decoding="async" width="90%" src="https://vereego.fr/wp-content/uploads/2020/12/app-store-img-1.png" alt="App Store">
          </a>
        </div>
        <div>
          <a href="https://play.google.com/store/apps/details?id=fr.vereego.app&amp;pli=1" target="_blank" rel="noopener">
            <img loading="lazy" decoding="async" width="90%" src="https://vereego.fr/wp-content/uploads/2020/12/google-play-img-1.png" alt="Google Play">
          </a>
        </div>
      </div>
    </div>

    <div class="center round_bg">
      <img src="<?php echo e($img['how_map']); ?>" alt="<?php echo e(__('map_capture_alt')); ?>">
    </div>
  </div>
</section>


<section class="section overlay-div">
  <div class="wrap grid-2" style="align-items:center">
    <div class="center round_bg">
      <img src="<?php echo e($img['form_mock']); ?>" alt="<?php echo e(__('form_alt')); ?>">
    </div>
    <div>
      <img src="<?php echo e($img['easy']); ?>" alt="" style="margin-bottom:25px">
      <h2 class="title"><?php echo e(__('simple_precise_title')); ?></h2>
      <p class="walk_txt"><?php echo e(__('simple_precise_text')); ?></p>
    </div>
  </div>
</section>


<section class="section overlay-div">
  <div class="wrap grid-2" style="align-items:center">
    <div>
      <h2 class="title"><?php echo e(__('flex_title')); ?></h2>
      <p class="walk_txt"><?php echo e(__('flex_text')); ?></p>
    </div>
    <div class="center round_bg">
      <img src="<?php echo e($img['card_mock']); ?>" alt="<?php echo e(__('card_share_alt')); ?>">
    </div>
  </div>
</section>


<section id="contact" class="section overlay-div">
  <div class="wrap">
    <h2 class="center title"><?php echo e(__('Nous contacter')); ?></h2>

    <?php if(session('ok')): ?> <div class="ok"><?php echo e(session('ok')); ?></div> <?php endif; ?>
    <?php if(session('err')): ?> <div class="err"><?php echo e(session('err')); ?></div> <?php endif; ?>

    <form class="form" method="POST" action="<?php echo e(lr('contact.send')); ?>">
      <?php echo csrf_field(); ?>

      
      <input type="text" name="website" style="display:none">
      <input type="hidden" name="started" value="<?php echo e(now()->toIso8601String()); ?>">

      <div style="margin-top:14px;text-align:center;display:grid;gap:10px">
        <input class="input" type="text"   name="name"    placeholder="<?php echo e(__('Nom')); ?>" value="<?php echo e(old('name')); ?>" required>
        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="err"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

        <input class="input" type="email"  name="email"   placeholder="<?php echo e(__('Email')); ?>" value="<?php echo e(old('email')); ?>" required>
        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="err"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

        <textarea class="input" name="message" placeholder="<?php echo e(__('Message')); ?>" rows="6" required><?php echo e(old('message')); ?></textarea>
        <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="err"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

        <button class="btn primary" style="font-size:16px" type="submit"><?php echo e(__('Envoyer')); ?></button>
      </div>
    </form>
  </div>
</section>


<section class="cta-final hero" id="appstore">
  <div class="wrap">
    <h2><?php echo e(__('cta_title')); ?></h2>
    <div class="badges center" style="justify-content:center;margin-top:14px">
      <a href="https://apps.apple.com/us/app/vereego/id6479544906" target="_blank" rel="noopener">
        <img loading="lazy" decoding="async" width="100%" src="<?php echo e($img['appstore']); ?>" alt="App Store">
      </a>
      <a href="https://play.google.com/store/apps/details?id=fr.vereego.app&amp;pli=1" target="_blank" rel="noopener">
        <img loading="lazy" decoding="async" width="100%" src="<?php echo e($img['playstore']); ?>" alt="Google Play">
      </a>
    </div>
    <div class="footer" style="margin-top:28px;font-size:14px;opacity:.6">
      © <?php echo e(date('Y')); ?> Vereego — <?php echo e(__('rights_reserved')); ?>

    </div>
  </div>
</section>

<script src="/assets/js/global.js" crossorigin="anonymous"></script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.base', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/raph/Sites/vereego/resources/views/welcome.blade.php ENDPATH**/ ?>