<?php $__env->startSection('title', __('My itineraries')); ?>

<?php $__env->startSection('content'); ?>
<div class="wrap">
  <h2 style="margin:0 0 12px;"><?php echo e(__('My itineraries')); ?></h2>

  <?php if(session('ok')): ?>
    <div class="ok"><?php echo e(session('ok')); ?></div>
  <?php endif; ?>

  <?php if($itins->isEmpty()): ?>
    <div class="alert"><?php echo e(__('No itinerary assigned to your account yet.')); ?></div>
  <?php else: ?>
    <div class="card">
      <div class="card-body" style="overflow:auto">
        <table class="table">
          <thead>
            <tr>
              <th><?php echo e(__('Name')); ?></th>
              <th><?php echo e(__('Scheduled date')); ?></th>
              
              <th><?php echo e(__('Owner')); ?></th>
              <th><?php echo e(__('Points')); ?></th>
              
              <th></th>
            </tr>
          </thead>
          <tbody>
          <?php $__currentLoopData = $itins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $it): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
              <td><?php echo e($it->name); ?></td>
              <td>
                <?php echo e($it->scheduled_date
                    ? localized_date($it->scheduled_date)
                    : '—'); ?>

              </td>
              
              <td>
                <?php $o = $it->owner; ?>
                <?php echo e($o ? trim(($o->firstname ?? '').' '.($o->lastname ?? '')) : '—'); ?>

              </td>
              <td><?php echo e($it->points_count ?? $it->points()->count()); ?></td>
              
                  
              <td style="text-align:right;">
                <a class="btn small"
                   href="<?php echo e(route('itins.user.map', ['locale'=>app()->getLocale(), 'itinerary'=>$it->id])); ?>">
                  <?php echo e(__('Map')); ?>

                </a>
              </td>
            </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody>
        </table>
      </div>
    </div>
  <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.base', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/raph/Sites/vereego/resources/views/itins/mine.blade.php ENDPATH**/ ?>