<?php 
    $token = $p->serial ?? null; 
    $favoriteIds = [];
        if (auth()->check()) {
            // Récupère les IDs de points favoris de l'utilisateur connecté
            $favoriteIds = auth()->user()
                ->favoritePoints()
                ->pluck('points.id')   // ou ->pluck('point_id') selon ta relation
                ->all();
        }
?>

<?php $__env->startSection('title','Mes waypoints'); ?>

<?php $__env->startSection('content'); ?>

<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css">
<link rel="stylesheet" href="https://unpkg.com/leaflet.locatecontrol@0.84.2/dist/L.Control.Locate.min.css">

<link rel="stylesheet" href="/assets/css/vereego.css">


<div class="wrap">

    <form id="search-form" method="GET" action="<?php echo e(lr('search')); ?>" class="filters">

        <div class="form-grid">
            <div class="form-field">
                <input id="search-input" type="text" name="q" value="<?php echo e($q ?? ''); ?>" placeholder="<?php echo e(__('Search')); ?> VereeGo (<?php echo e(__('Name')); ?>, <?php echo e(__('City')); ?>…)" />
            </div>
            <div class="form-field" style="flex-direction: initial;">
                
                <button type="button" id="btn-all" class="btn small ghost" style="height: 50px; width: 50%"><?php echo e(__('All points')); ?></button>
        </div>
       </div>
    </form>

    <div id="map"></div>


    <?php if(session('ok')): ?>
        <div class="ok"><?php echo e(session('ok')); ?></div>
    <?php endif; ?>

    <ul id="points-list" class="points" style="display:grid; grid-template-columns: repeat(auto-fit,minmax(280px,1fr)); gap:12px; list-style:none; padding:0;">
        <?php $__empty_1 = true; $__currentLoopData = $points; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <?php
                $token = $p->serial ?? null;
                $searchData = strtolower(trim(implode(' ', array_filter([
                    $p->name ?? '',
                    $p->address1 ?? '',
                    $p->address2 ?? '',
                    $p->postcode ?? '',
                    $p->city ?? '',
                    $p->country_isocode ?? '',
                ]))));
                $addressData = trim(($p->address1 ?? '').' '.($p->postcode ?? '').' '.($p->city ?? ''));
            ?>

            <li
                class="card" 
                data-id="<?php echo e($p->id); ?>"
                data-name="<?php echo e($p->name); ?>"
                data-lat="<?php echo e($p->latitude); ?>"
                data-lng="<?php echo e($p->longitude); ?>"
                data-search="<?php echo e($searchData); ?>"
                data-address="<?php echo e($addressData); ?>"
                style="border:var(--border); border-radius:8px; padding:12px; color: var(--primary);"
            >                           
                <div class="flex items-center justify-between gap-2 py-2">
                    <div class="flex-1">
                        <div style="font-weight:700"><?php echo e($p->name); ?></div>
                    </div>

                    
                    <?php
                        $token = $p->serial ?? null;
                        $isFav = auth()->check() && in_array($p->id, $favoriteIds, true);
                    ?>
                    <?php if($token): ?>
                        <button
                            class="star-btn fav-btn"
                            data-url="<?php echo e(lr('points.favorite', ['token' => $token])); ?>"
                            style="line-height:0; background:transparent; border:0; cursor:pointer"
                            aria-label="<?php echo e(__('Toggle favorite')); ?>"
                            title="<?php echo e(__('Favorite')); ?>"
                        >
                            <?php if($isFav): ?>
                                
                                <svg width="22" height="22" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true">
                                    <path d="M12 17.27 18.18 21l-1.64-7.03L22 9.24l-7.19-.62L12 2 9.19 8.62 2 9.24l5.46 4.73L5.82 21z"/>
                                </svg>
                            <?php else: ?>
                                
                                <svg width="22" height="22" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                                    stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-hidden="true">
                                    <polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21 12 17.77 5.82 21 7 14.14 2 9.27 8.91 8.26 12 2"/>
                                </svg>
                            <?php endif; ?>
                        </button>
                    <?php endif; ?>
                </div>

                <div style="font-size:.9em; color:#6b7280">
                    <?php echo e(__('Latitude')); ?> : <?php echo e($p->latitude); ?>, <?php echo e(__('Longitude')); ?> : <?php echo e($p->longitude); ?>

                </div>

                <?php if(!empty($p->address1) || !empty($p->city)): ?>
                    <div style="margin-top:.25rem;">
                        <?php echo e($p->address1); ?><br>
                        <?php echo e($p->postcode); ?> <?php echo e($p->city); ?> <?php echo e($p->country_isocode ? '(' . $p->country_isocode . ')' : ''); ?>

                    </div>
                <?php endif; ?>

                <?php $canShare = auth()->id() === 1 || $p->user_id === auth()->id(); ?>
                <?php if(isset($p->owner)): ?>
                    <div style="margin-top:.25rem; font-size:.85em; color:#6b7280">
                        <?php if($p->owner->id == 0): ?>
                            <?php echo e($p->owner->firstname); ?> <?php echo e($p->owner->lastname); ?>

                        <?php else: ?>
                            <?php echo e(__('Owner')); ?> : <?php echo e($p->owner->firstname); ?> <?php echo e($p->owner->lastname); ?> (<?php echo e($p->owner->email); ?>)
                        <?php endif; ?>
                    </div>
                <?php endif; ?>

                <div class="actions" style="display:flex; gap:.5rem; margin-top:.5rem; flex-wrap:wrap;">
                    <?php $token = $p->serial ?? null; ?>
                    <?php if($token): ?>
                        <?php if($canShare): ?>
                            <a class="btn small ghost" href="<?php echo e(lr('points.public', ['token' => $token])); ?>"><?php echo e(__('Detail')); ?></a>
                        <?php else: ?>
                            <a class="btn small ghost" href="<?php echo e(lr('points.public.readonly', ['token' => $token])); ?>"><?php echo e(__('Detail')); ?></a>
                        <?php endif; ?>
                    <?php else: ?>
                        <button class="btn small ghost" disabled title="<?php echo e(__('No serial yet')); ?>">
                            <?php echo e(__('Detail')); ?>

                        </button>
                    <?php endif; ?>

                    
                    <?php if(auth()->guard()->check()): ?>
                         <?php if($canShare): ?>
                            <details class="share-box">
                                <summary class="btn small ghost"><?php echo e(__('Sharing')); ?></summary>
                                
                                <form method="POST"
                                      action="<?php echo e($token ? route('points.share', ['locale' => app()->getLocale(), 'token' => $token]) : '#'); ?>"
                                      class="share-form">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="point" value="<?php echo e($token); ?>">
                                    <label>Email du destinataire
                                        <input type="email" name="email" required placeholder="ex: user@exemple.com">
                                    </label>
                                    <div class="row">
                                        <label>Début (optionnel)
                                            <input type="datetime-local" name="start_at">
                                        </label>
                                        <label>Fin (optionnel)
                                            <input type="datetime-local" name="end_at">
                                        </label>
                                    </div>
                                    <button type="submit" class="btn small ghost" <?php echo e($token ? '' : 'disabled'); ?>>
                                        Partager
                                    </button>
                                </form>

                                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="err"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </details>

                            <form method="POST" action="<?php echo e(lr('points.destroy', ['point' => $p->id])); ?>"
                                  style="display:inline;" onsubmit="return confirm('<?php echo e(__('Delete this waypoint')); ?> ?');">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn small danger" style="margin-top: 0.5rem;"><?php echo e(__('Delete')); ?></button>
                            </form>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
            </li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <li><?php echo e(__('No waypoint found')); ?></li>
        <?php endif; ?>
    </ul>

    <div style="margin-top:1rem;">
        <?php echo e($points->links()); ?>

    </div>
</div>

<?php
    // If $points is a paginator, keep only the items.
    if ($points instanceof \Illuminate\Pagination\AbstractPaginator) {
        $pointsArray = $points->items(); // plain PHP array
    } else {
        // Collection or array -> force a zero-indexed array
        $pointsArray = is_iterable($points) ? collect($points)->values()->all() : [];
    }
?>




<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js" defer></script>
<script src="https://unpkg.com/leaflet.locatecontrol@0.84.2/dist/L.Control.Locate.min.js" defer></script>

<script>

    document.addEventListener('DOMContentLoaded', () => {
    

        // --- Leaflet map ---
        const map = L.map('map').setView([46.5, 2.5], 6);
        L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
            attribution: '&copy; OpenStreetMap contributors', maxZoom: 19
        }).addTo(map);
        L.control.locate({ position: 'topleft', flyTo: true, strings:{ title:'<?php echo e(__('Center on my position')); ?>' } }).addTo(map);

        // --- Selectors ---
        const listEl  = document.getElementById('points-list');
        const formEl  = document.getElementById('search-form');
        const inputEl = document.getElementById('search-input');
        const btnAll  = document.getElementById('btn-all');

        // --- Build markers from the DOM ---
        const items = Array.from(listEl.querySelectorAll('li[data-id]'));
        const markers = new Map();          // id -> marker
        const markersGroup = L.layerGroup().addTo(map);
        const allBounds = L.latLngBounds([]);

        items.forEach(li => {
            const id  = li.dataset.id;
            const lat = parseFloat(li.dataset.lat);
            const lng = parseFloat(li.dataset.lng);
            if (isNaN(lat) || isNaN(lng)) return;

            const title = li.dataset.name || '—';
            const addr  = li.dataset.address || '';
            const html  = `<b>${title}</b>${addr ? `<br>${addr}` : ''}`;

            const m = L.marker([lat, lng]).bindPopup(html);
            markers.set(id, m);
            markersGroup.addLayer(m);
            allBounds.extend([lat, lng]);
        });

        if (allBounds.isValid()) map.fitBounds(allBounds.pad(0.2));

        // --- Filtering (list + map) ---
        function applyFilter(query) {
            const q = (query || '').trim().toLowerCase();
            const matchedIds = [];

            // List: show/hide according to the blob
            items.forEach(li => {
                const blob = li.dataset.search || '';
                const ok = !q || blob.includes(q);
                li.style.display = ok ? '' : 'none';
                if (ok) matchedIds.push(li.dataset.id);
            });

            // Map: rebuild the layer with matching markers only
            markersGroup.clearLayers();
            const b = L.latLngBounds([]);
            matchedIds.forEach(id => {
                const m = markers.get(id);
                if (m) {
                    markersGroup.addLayer(m);
                    b.extend(m.getLatLng());
                }
            });

            if (b.isValid()) {
                map.fitBounds(b.pad(0.2));
            } else if (allBounds.isValid()) {
                // if nothing matches, reset to the global view
                map.fitBounds(allBounds.pad(0.2));
            }
        }

        // --- UX: form submission -> client-side filtering ---
        formEl.addEventListener('submit', (e) => {
            e.preventDefault();
            applyFilter(inputEl.value);
        });

        // --- UX: live filtering (light debounce) ---
        let t = null;
        inputEl.addEventListener('input', () => {
            clearTimeout(t);
            t = setTimeout(() => applyFilter(inputEl.value), 150);
        });

        // --- “All points” button ---
        btnAll.addEventListener('click', () => {
            inputEl.value = '';
            applyFilter('');
        });

        // --- Favorite toggle (unchanged) ---
        document.addEventListener('click', async (e) => {
            const btn = e.target.closest('.fav-btn');
            if (!btn) return;

            const url = btn.dataset?.url;
            if (!url) return;

            const filled = `<svg width="22" height="22" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true"><path d="M12 17.27 18.18 21l-1.64-7.03L22 9.24l-7.19-.62L12 2 9.19 8.62 2 9.24l5.46 4.73L5.82 21z"/></svg>`;
            const empty  = `<svg width="22" height="22" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-hidden="true"><polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21 12 17.77 5.82 21 7 14.14 2 9.27 8.91 8.26 12 2"/></svg>`;

            try {
                const res = await fetch(url, {
                method: 'POST',
                credentials: 'same-origin', // 👈 IMPORTANT: send session cookie
                headers: {
                    'Accept': 'application/json',
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                },
                });

                if (res.status === 401) {
                // not logged in → go to localized login
                window.location.href = "<?php echo e(lr('login')); ?>";
                return;
                }

                const txt  = await res.text();
                let data   = null;
                try { data = JSON.parse(txt); } catch (_) {}

                if (!res.ok || !data || typeof data.favoris === 'undefined') {
                console.error('Favorite toggle failed', res.status, url, txt);
                alert("Impossible de mettre à jour le favori pour le moment.");
                return;
                }

                btn.innerHTML = Number(data.favoris) > 0 ? filled : empty;
            } catch (err) {
                console.error('Favorite network error —', err);
                alert("Impossible de mettre à jour le favori pour le moment.");
            }
        });
 
    });
</script>






<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.base', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/raph/Sites/vereego/resources/views/points/search.blade.php ENDPATH**/ ?>