<?php
    /** @var \App\Models\Point|null $p */
    $pt = $p ?? null;
    
    
 // ← always from route param {token}
    $routeToken  = request()->route('token');
    $serialToken = $serialToken ?? $routeToken ?? ($pt->serial ?? null);
 
    $serial       = $serialToken ?? ($pt->serial ?? null);

    // URLs médias
    $photoUrl = ($pt && !empty($pt->photo))  ? Storage::url($pt->photo)  : null;
    $qrUrl    = ($pt && !empty($pt->qrcode)) ? Storage::url($pt->qrcode) : null;

    // Read-only URL
    $readonlyUrl = $serialToken ? route('points.public.readonly', ['locale' => app()->getLocale(), 'token' => $serialToken]) : null;

    // Adresse complète (chaînes uniquement)
    $fullAddress = $pt ? trim(implode(' ', array_filter([
        $pt->address1 ?? null, $pt->address2 ?? null,
        $pt->postcode ?? null, $pt->city ?? null, $pt->country_isocode ?? null,
    ]))) : '';

    // URL de partage (prend readonly si dispo, sinon l’URL courante)
    $shareUrl = url()->current();
    $readonly = (bool)($readonly ?? false);

    $locale = app()->getLocale();
?>

<?php $__env->startSection('title', $pt?->name ? ($pt->name . ' — ' . $serialToken) : __('Waypoint')); ?>

<?php $__env->startSection('content'); ?>
 
    <?php if(!$pt): ?>
        <?php
            $debugInfo = $pt?->serial ? '(' . $pt->serial . ')' : 'bad';
        ?>
        <div class="wrap">
            <div class="alert danger">
                <?php echo e(__('This waypoint does not exist or is no longer available.')); ?> <?php echo e($debugInfo); ?> <?php echo e(__('Token:')); ?> <code><?php echo e($serialToken); ?></code>
            </div>
        </div>
        
        <?php if(!empty($serialToken)): ?>
            <p>
                <a class="btn ghost" href="<?php echo e(lr('points.public.readonly', ['token' => $serialToken])); ?>">
                <?php echo e(__('Open read-only view')); ?>

                </a>
            </p>
        <?php endif; ?>
    <?php else: ?>
        <div class="wrap">
            <div class="card">
                <div class="card-header">
                    <div class="title"><?php echo e($pt->name); ?></div>

                    
                    <?php if(auth()->guard()->check()): ?>
                        <?php if($serialToken): ?>
                            <button type="button"
                                class="star-btn fav-btn"
                                data-url="<?php echo e(lr('points.favorite', ['token' => $serialToken])); ?>"
                                style="line-height:0; background:transparent; border:0; cursor:pointer"
                                aria-label="<?php echo e(__('Toggle favorite')); ?>"
                                title="<?php echo e(__('Favorite')); ?>"
                            >
                                <?php if((int)($pt->favoris ?? 0) > 0): ?>
                                    <svg width="22" height="22" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true">
                                        <path d="M12 17.27 18.18 21l-1.64-7.03L22 9.24l-7.19-.62L12 2 9.19 8.62 2 9.24l5.46 4.73L5.82 21z"/>
                                    </svg>
                                <?php else: ?>
                                    <svg width="22" height="22" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                                        stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-hidden="true">
                                        <polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21 12 17.77 5.82 21 7 14.14 2 9.27 8.91 8.26 12 2"/>
                                    </svg>
                                <?php endif; ?>
                            </button>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>

                 
                <div class="card-body">
                    <div class="panel">
                        <h4><?php echo e(__('Map')); ?></h4>
                        <div id="map" class="leaflet-container"></div>

                        <?php if($pt && $pt->latitude && $pt->longitude): ?>
                            <div class="map-actions" style="margin-top:1rem; text-align:center; display:flex; gap:1rem; justify-content:center; flex-wrap:wrap;">

                                
                                <a class="btn small ghost"
                                href="http://maps.apple.com/?daddr=<?php echo e($pt->latitude); ?>,<?php echo e($pt->longitude); ?>"
                                target="_blank" rel="noopener"
                                style="display:flex; align-items:center; gap:.5rem;">
                                    
                                    <svg id="Layer_1" xmlns="http://www.w3.org/2000/svg" version="1.1" width="18" height="18" fill="currentColor" viewBox="0 0 24 24">
                                        <path d="M10.6,6.9c.8.2,1.4.4,1.6.4s.9-.1,1.7-.4c.8-.3,1.5-.4,2.1-.4,1,0,1.8.3,2.6.8.4.3.8.7,1.3,1.2-.6.5-1.1,1-1.4,1.4-.5.7-.8,1.6-.8,2.5s.3,1.9.8,2.7c.6.8,1.2,1.3,1.9,1.5-.3,1-.8,2-1.5,3-1,1.6-2.1,2.4-3.1,2.4s-1-.1-1.7-.4c-.7-.3-1.3-.4-1.8-.4s-1.1.1-1.7.4c-.6.3-1.2.4-1.6.4-1.2,0-2.4-1-3.6-3.1-1.2-2.1-1.7-4.1-1.7-6s.4-3.3,1.3-4.5c.9-1.2,2-1.7,3.4-1.7s1.3.1,2.1.4ZM15.8,2.2c0,0,0,.2,0,.2,0,.5-.1,1-.4,1.6-.2.6-.6,1.1-1.1,1.6-.4.4-.9.7-1.3.9-.3,0-.7.2-1.2.2,0-1.2.3-2.2.9-3.1.6-.9,1.6-1.5,3-1.8,0,.1,0,.2,0,.3Z"/>
                                    </svg>
                                    <?php echo e(__('Apple Maps')); ?>

                                </a>

                                
                                <a class="btn small ghost"
                                href="https://www.google.com/maps/dir/?api=1&destination=<?php echo e($pt->latitude); ?>,<?php echo e($pt->longitude); ?>"
                                target="_blank" rel="noopener"
                                style="display:flex; align-items:center; gap:.5rem;">
                                    
                                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" fill="currentColor" viewBox="0 0 24 24">
                                        <path d="M12 2a7.99 7.99 0 0 0-8 8c0 5.25 8 12 8 12s8-6.75 8-12a7.99 7.99 0 0 0-8-8Zm0 11a3 3 0 1 1 0-6 3 3 0 0 1 0 6Z"/>
                                    </svg>
                                    <?php echo e(__('Google Maps')); ?>

                                </a>

                            </div>
                        <?php endif; ?>

                    </div>
                </div>
                <div class="media-grid">
                    <div class="panel">
                        <h4><?php echo e(__('Media')); ?></h4>

                        
                        <div class="imgbox" style="margin-bottom:10px; background: url(<?php echo e($photoUrl); ?>) no-repeat center/contain; min-height:260px">
                            <?php if($photoUrl): ?>
                                <a href="<?php echo e($photoUrl); ?>" target="_blank" rel="noopener">
                                    
                                </a>
                            <?php else: ?>
                                <div style="color:#6b7280;font-size:.9rem;padding:12px"><?php echo e(__('No photo')); ?></div>
                            <?php endif; ?>
                        </div>

                        
                        <?php if(auth()->guard()->check()): ?>
                            <?php if(!$readonly): ?>
                                <form method="POST"
                                    action="<?php echo e(route('points.update.photo', ['locale' => app()->getLocale()])); ?>"
                                    enctype="multipart/form-data">
                                
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PUT'); ?>

                                    <input id="photo-input" name="photo" type="file" accept="image/*" hidden onchange="this.form.submit()">
                                    
                                    <input type="hidden" name="serial" value="<?php echo e($pt->serial); ?>">

                                    <button type="button" class="btn primary" style="padding: 2px 18px !important;" onclick="document.getElementById('photo-input').click()">
                                        <?php echo e(__('Import')); ?>

                                    </button>
                                    <?php if($photoUrl): ?>
                                        <div style="font-size:.85rem; color:#a7acb4;"><?php echo e(__('Replace existing photo')); ?></div>
                                    <?php else: ?>
                                        <div style="font-size:.85rem; color:#a7acb4;"><?php echo e(__('Add a photo')); ?></div>
                                    <?php endif; ?>
                                </form>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                    <div class="panel">
                           <h4><?php echo e(__('QR Code')); ?></h4>
                
                        
                        <div class="imgbox">
                            <?php
                                //$qrUrl = $point && $point->qrcode ? Storage::url($point->qrcode) : null;
                                $qrUrl = $pt->qrcode ? Storage::url($pt->qrcode) : null;
                            ?>
                                <?php if($qrUrl): ?>
                                    <a href="<?php echo e($qrUrl); ?>" target="_blank" rel="noopener">
                                        <img
                                        src="<?php echo e($qrUrl); ?>"
                                        alt="QR Code"
                                        width="256" height="256"
                                        loading="lazy" decoding="async"
                                        style="display:block;max-width:100%;height:auto"
                                        onerror="this.replaceWith(Object.assign(document.createElement('object'),{data:this.src,type:'image/svg+xml',width:this.width,height:this.height}));"
                                        >
                                    </a>
                                <?php else: ?>
                                    <div class="alert"><?php echo e(__('QR code unavailable')); ?></div>
                                <?php endif; ?>
                            </div>

                        </div>
                    </div>
                </div>

                
                 <div class="form-card" >
                    <?php if (! (empty($readonly))): ?>
                        <div class="kv">
                        
                            <div class="key"><?php echo e(__('Coordinates')); ?></div>
                            <div class="val">
                                <span>lat :</span> <?php echo e(number_format((float)$pt->latitude, 6, '.', ' ')); ?> <br>
                                <span>lon :</span> <?php echo e(number_format((float)$pt->longitude, 6, '.', ' ')); ?> <br>
                                <?php if(!is_null($pt->altitude)): ?>
                                    <span>alt :</span> <?php echo e((float)$pt->altitude); ?> m<br>
                                <?php endif; ?>
                                <?php if(!is_null($pt->floor) && $pt->floor > 0): ?>
                                    <span>floor :</span> <?php echo e((float)$pt->floor); ?><br>
                                <?php endif; ?>
                            </div>

                            <?php if($fullAddress !== ''): ?>
                                <div class="key"><?php echo e(__('Address')); ?></div>
                                <div class="val"><?php echo e($fullAddress); ?></div>
                            <?php endif; ?>

                            <?php if(!empty($pt->comment)): ?>
                                <div class="key"><?php echo e(__('Comment')); ?></div>
                                <div class="val"><?php echo e($pt->comment); ?></div>
                            <?php endif; ?>

                            
                            <?php if(!empty($readonly) && $readonly === true && isset($pt)): ?>
                                <div style="margin-top:14px">
                                    <button type="button" class="btn danger" id="open-report-modal">
                                        <?php echo e(__('Report this waypoint')); ?>

                                    </button>
                                </div>

                                
                                <dialog id="report-modal" style="max-width: 520px; width: 92%; border:1px solid #1f2430; border-radius:10px; padding:0;">
                                    <form method="POST" action="<?php echo e(route('reporting.store')); ?>" style="padding:16px 16px 8px 16px">
                                        <?php echo csrf_field(); ?>

                                        <h3 style="margin:0 0 10px 0"><?php echo e(__('Report this waypoint')); ?></h3>
                                        <p style="color:#9aa0a6; margin-top:0"><?php echo e(__('Tell us what is wrong or why this waypoint should be reviewed.')); ?></p>

                                        <input type="hidden" name="point_id" value="<?php echo e($pt->id); ?>"/>

                                        <div class="form-field" style="margin-bottom:10px">
                                            <label for="report-email" style="display:block; font-weight:600"><?php echo e(__('Your email (optional)')); ?></label>
                                            <input id="report-email" type="email" name="email" placeholder="you@example.com" style="width:100%">
                                        </div>

                                        <div class="form-field" style="margin-bottom:12px">
                                            <label for="report-message" style="display:block; font-weight:600"><?php echo e(__('Message')); ?></label>
                                            <textarea id="report-message" name="message" required rows="5" style="width:100%"></textarea>
                                        </div>

                                        <div style="display:flex; gap:.5rem; justify-content:flex-end; border-top:1px solid #1f2430; padding-top:10px; margin-top:10px;">
                                            <button type="button" id="close-report-modal" class="btn ghost"><?php echo e(__('Cancel')); ?></button>
                                            <button type="submit" class="btn primary"><?php echo e(__('Submit')); ?></button>
                                        </div>
                                    </form>
                                </dialog>

                                <script>
                                    (function(){
                                        const openBtn  = document.getElementById('open-report-modal');
                                        const closeBtn = document.getElementById('close-report-modal');
                                        const dialog   = document.getElementById('report-modal');

                                        if (!openBtn || !dialog) return;

                                        openBtn.addEventListener('click', () => {
                                            if (typeof dialog.showModal === 'function') {
                                                dialog.showModal();
                                            } else {
                                                // fallback if <dialog> not supported
                                                dialog.style.display = 'block';
                                            }
                                        });

                                        if (closeBtn) {
                                            closeBtn.addEventListener('click', () => {
                                                if (typeof dialog.close === 'function') {
                                                    dialog.close();
                                                } else {
                                                    dialog.style.display = 'none';
                                                }
                                            });
                                        }
                                    })();
                                </script>
                            <?php endif; ?>
                            <!-- <div class="key">Favori</div>
                            <div class="val" id="kv-favori"><?php echo e((int)($pt->favoris ?? 0) > 0 ? 'Oui' : 'Non'); ?></div>-->
                        </div> 
    
                    <?php endif; ?>

                    
                    

                    <div class="hr"></div>

                    
                    <?php if(session('status')): ?>
                        <div class="alert" style="margin-top:16px"><?php echo e(session('status')); ?></div>
                    <?php endif; ?>
                    <?php if($errors->any()): ?>
                        <div class="alert" style="margin-top:16px">
                            <strong><?php echo e(__('Errors')); ?> :</strong>
                            <ul style="margin:6px 0 0 16px;">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>

                    
                    <?php if($pt && !empty($pt->serial) && $serialToken): ?>
                        <?php if (! (!empty($readonly))): ?>
                            
                            <form method="POST" action="<?php echo e(route('points.update.serial', ['locale' => app()->getLocale(), 'serial' => $serialToken])); ?>">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('PUT'); ?>

                                <div class="form-grid">
                                    <div class="form-field">
                                        <label for="lastname"><?php echo e(__('Name')); ?></label>
                                        <input id="lastname" type="text" name="name" value="<?php echo e(old('name', $pt->name)); ?>" required>
                                    </div>
                                 </div>

                                <div class="form-grid">
                                    <div class="form-field">
                                        <label for="latitude"><?php echo e(__('Latitude')); ?></label>
                                        <input id="latitude" type="number" step="0.000001" name="latitude" value="<?php echo e(old('latitude', $pt->latitude)); ?>" required>
                                    </div>
                                    <div class="form-field">
                                        <label for="longitude"><?php echo e(__('Longitude')); ?></label>
                                        <input id="longitude" type="number" step="0.000001" name="longitude" value="<?php echo e(old('longitude', $pt->longitude)); ?>" required>
                                    </div>
                                    <div class="form-field">
                                        <label for="altitude"><?php echo e(__('Altitude')); ?> (m)</label>
                                        <input id="altitude" type="number" step="0.1" name="altitude" value="<?php echo e(old('altitude', $pt->altitude)); ?>">
                                    </div>
                                    <div class="form-field">
                                        <label for="floor"><?php echo e(__('Floor')); ?> (m)</label>
                                        <input id="floor" type="number" step="0.1" name="floor" value="<?php echo e(old('floor', $pt->floor)); ?>">
                                    </div>
                                </div>

                                
                                <div class="form-grid">
                                    <div class="form-field">
                                        <label for="address1"><?php echo e(__('Address1')); ?></label>
                                        <input id="address1" type="text" name="address1" value="<?php echo e(old('address1', $pt->address1)); ?>">
                                     </div>
                                    <div class="form-field">
                                        <label for="address2"><?php echo e(__('Address2')); ?> </label>
                                        <input id="address2" type="text" name="address2" value="<?php echo e(old('address2', $pt->address2)); ?>">
                                    </div>
                                </div>

                                 <div class="form-grid">
                                    <div class="form-field">
                                        <label for="postcode"><?php echo e(__('Postcode')); ?></label>
                                        <input id="postcode" type="text" name="postcode" value="<?php echo e(old('postcode', $pt->postcode)); ?>">
                                    </div>
                                     <div class="form-field">
                                        <label for="city"><?php echo e(__('City')); ?></label>
                                        <input id="city" type="text" name="city" value="<?php echo e(old('city', $pt->city)); ?>">
                                     </div>
                                     <div class="form-field">
                                        <label for="country_isocode"><?php echo e(__('country_isocode')); ?></label>
                                        <input id="country_isocode" type="text" name="country_isocode" value="<?php echo e(old('country_isocode', $pt->country_isocode)); ?>">
                                    </div>
                                </div>

                                 <div class="form-grid">
                                    <div class="form-field">
                                        <label for="comment"><?php echo e(__('Comment')); ?></label>
                                        <textarea id="comment" name="comment"><?php echo e(old('comment', $pt->comment)); ?></textarea>
                                    </div>
                                </div>

                                <div class="actions">
                                <a href="<?php echo e(url()->previous()); ?>" class="btn"><?php echo e(__('Cancel')); ?></a>
                                <button class="btn primary" type="submit"><?php echo e(__('Save')); ?></button>
                                </div>
                            </form>
                        <?php endif; ?>
                    <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>





        
        
        






       
        <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css"/>
        <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js" defer></script>

        <script>
            document.addEventListener('DOMContentLoaded', () => {
                const mapEl = document.getElementById('map');
                if (!mapEl) return;
                if (typeof window.L === 'undefined') { console.error('Leaflet non chargé'); return; }

                const lat = <?php echo e((float)$pt->latitude); ?>;
                const lon = <?php echo e((float)$pt->longitude); ?>;

                const map = L.map('map', { scrollWheelZoom: true }).setView([lat, lon], 14);
                L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                    maxZoom: 19, attribution: '&copy; OpenStreetMap'
                }).addTo(map);

                L.marker([lat, lon]).addTo(map).bindPopup(<?php echo json_encode($pt->name); ?>);
            });







            // Favorite
        document.addEventListener('click', async (e) => {
            const btn = e.target.closest('.fav-btn');
            if (!btn) return;

            const url = btn.dataset?.url;
            if (!url) return;

            try {
                const res = await fetch(url, {
                method: 'POST',
                credentials: 'same-origin', // 👈 indispensable pour envoyer le cookie de session
                headers: {
                    'Accept': 'application/json',
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                },
                });

                if (res.status === 401) {
                    // pas connecté → redirige vers login localisé
                    window.location.href = "<?php echo e(lr('login')); ?>";
                    return;
                }

                if (res.status === 403) {
                    const j = await res.json().catch(()=>({}));
                    alert(j?.error === 'forbidden'
                    ? "Action non autorisée (réservée au propriétaire ou super-admin)."
                    : "Action interdite.");
                    return;
                }

                const text = await res.text();
                let json = null;
                try { json = JSON.parse(text); } catch(_) {}

                if (!res.ok) {
                    console.error('Favorite toggle failed', res.status, url, text || json);
                    alert('Impossible de mettre à jour le favori pour le moment.');
                    return;
                }

                const favoris = json?.favoris ?? null;
                if (favoris === null) {
                    console.error('Favorite response missing "favoris"', json);
                    alert('Impossible de mettre à jour le favori pour le moment.');
                    return;
                }

                // Met à jour l’icône (plein/vide)
                const filled = `<svg width="22" height="22" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true"><path d="M12 17.27 18.18 21l-1.64-7.03L22 9.24l-7.19-.62L12 2 9.19 8.62 2 9.24l5.46 4.73L5.82 21z"/></svg>`;
                const empty  = `<svg width="22" height="22" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-hidden="true"><polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21 12 17.77 5.82 21 7 14.14 2 9.27 8.91 8.26 12 2"/></svg>`;
                btn.innerHTML = (Number(favoris) > 0) ? filled : empty;
            } catch (err) {
                console.error('Favorite network error', err);
                alert('Impossible de mettre à jour le favori pour le moment.');
            }
        });







            // Partage
            document.addEventListener('DOMContentLoaded', () => {
            const shareBtn = document.getElementById('share-btn');
            const fallback = document.getElementById('share-fallback');
            const copyBtn  = document.getElementById('copy-link-btn');

            if (shareBtn) {
                shareBtn.addEventListener('click', async () => {
                const title = shareBtn.dataset.title || 'Partager';
                const text  = shareBtn.dataset.text  || '';
                const url   = shareBtn.dataset.url   || location.href;

                if (navigator.share) {
                    try { await navigator.share({ title, text, url }); }
                    catch (err) { if (!err || err.name !== 'AbortError') { if (fallback) fallback.style.display = 'block'; } }
                } else {
                    if (fallback) fallback.style.display = 'block';
                }
                });
            }

            if (copyBtn) {
                copyBtn.addEventListener('click', async () => {
                const url = copyBtn.dataset.url || location.href;
                try {
                    await navigator.clipboard.writeText(url);
                    copyBtn.textContent = 'Lien copié ✓';
                    setTimeout(() => (copyBtn.textContent = 'Copier le lien'), 1500);
                } catch {
                    const ta = document.createElement('textarea');
                    ta.value = url; document.body.appendChild(ta); ta.select(); document.execCommand('copy'); document.body.removeChild(ta);
                    copyBtn.textContent = 'Lien copié ✓';
                    setTimeout(() => (copyBtn.textContent = 'Copier le lien'), 1500);
                }
                });
            }
            });
        </script>

    <?php endif; ?> 


<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.base', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/raph/Sites/vereego/resources/views/points/public_show.blade.php ENDPATH**/ ?>