<?php $__env->startSection('title', __('Itineraries')); ?>

<?php $__env->startSection('content'); ?>
<?php
use Illuminate\Support\Facades\Route;

$routeName = Route::currentRouteName();
$isAdminNs = str_starts_with($routeName, 'admin.');
$locale    = app()->getLocale();

// Safe route builders
$createUrl = function() use ($isAdminNs, $locale) {
    if ($isAdminNs && Route::has('admin.itins.create')) {
        return route('admin.itins.create');
    }
    if (!$isAdminNs && Route::has('pro.itins.create')) {
        return route('pro.itins.create', ['locale'=>$locale]);
    }
    return '#';
};

$editUrl = function($it) use ($isAdminNs, $locale) {
    if ($isAdminNs && Route::has('admin.itins.edit')) {
        return route('admin.itins.edit', ['locale'=>app()->getLocale(), 'itinerary'=>$it->id]);
    }
    if (!$isAdminNs && Route::has('pro.itins.edit')) {
        return route('pro.itins.edit', ['locale'=>app()->getLocale(), 'itinerary'=>$it->id]);
    }
    return '#';
};

$destroyUrl = function($it) use ($isAdminNs, $locale) {
    if ($isAdminNs && Route::has('admin.itins.destroy')) {
        return route('admin.itins.destroy', ['locale'=>app()->getLocale(), 'itinerary'=>$it->id]);
    }
    if (!$isAdminNs && Route::has('pro.itins.destroy')) {
        return route('pro.itins.destroy', ['locale'=>$locale, 'itinerary'=>$it->id]);
    }
    return '#';
};

$updateUrl = function($it) use ($isAdminNs, $locale) {
    if ($isAdminNs && Route::has('admin.itins.update')) {
        return route('admin.itins.update', ['locale'=>app()->getLocale(), 'itinerary'=>$it->id]);
    }
    if (!$isAdminNs && Route::has('pro.itins.destroy')) {
        return route('pro.itins.update', ['locale'=>app()->getLocale(), 'itinerary'=>$itinerary->id]);
    }
    return '#';
};

$mapUrl = function($it) use ($isAdminNs, $locale) {
    if ($isAdminNs && Route::has('admin.itins.map')) {
        return route('admin.itins.map', ['locale'=>app()->getLocale(), 'itinerary'=>$it->id]);
    }
    if (!$isAdminNs && Route::has('pro.itins.map')) {
        return route('pro.itins.map', ['locale'=>$locale, 'itinerary'=>$it->id]);
    }
    return '#';
};
?>

<style>
    table { width:100%; border-collapse:collapse; margin-top:12px; }
    th, td { padding:10px 12px; border-bottom:1px solid var(--border-color,#252935); text-align:left; }
    th { background:#0c0e17; font-weight:600; }
    tr:hover td { border-bottom:1px solid var(--border-color,#252935);}
    .actions { display:flex; flex-wrap:wrap; gap:6px; }
    .muted { color:#a0a6af; font-size:0.9em; }
    .btn.small { padding:4px 10px; font-size:0.85em; }
    .wrap { max-width:1200px; margin:auto; }
</style>

<div class="wrap">
    <h2 style="margin:0 0 12px;"><?php echo e(__('Itineraries')); ?></h2>

    <?php if(session('ok')): ?>
        <div class="alert success"><?php echo e(session('ok')); ?></div>
    <?php endif; ?>

    <div style="margin-bottom:14px;">
        <a href="<?php echo e($createUrl()); ?>" class="btn primary">+ <?php echo e(__('Create an itinerary')); ?></a>
    </div>

    <?php if($itineraries->isEmpty()): ?>
        <div class="muted"><?php echo e(__('No itineraries found.')); ?></div>
    <?php else: ?>
        <table>
            <thead>
                <tr>
                    <th style="width:40px;">#</th>
                    <th><?php echo e(__('Name')); ?></th>
                    <th><?php echo e(__('Company')); ?></th>
                    <th><?php echo e(__('Pro admin')); ?></th>
                    <th><?php echo e(__('Users assigned')); ?></th>
                    <th style="width:210px;"><?php echo e(__('Actions')); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $itineraries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $it): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($it->id); ?></td>
                        <td><?php echo e($it->name); ?></td>
                        <td><?php echo e($it->society->name ?? '—'); ?></td>
                        <td>
                            <?php if($it->assignedAdmin): ?>
                                <?php echo e($it->assignedAdmin->firstname); ?> <?php echo e($it->assignedAdmin->lastname); ?>

                            <?php else: ?>
                                <span class="muted">—</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($it->assignedUsers && $it->assignedUsers->count()): ?>
                                <span title="<?php echo e($it->assignedUsers->pluck('firstname')->join(', ')); ?>">
                                    <?php echo e($it->assignedUsers->count()); ?>

                                </span>
                            <?php else: ?>
                                <span class="muted">0</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <div class="actions">
                                <a class="btn small" href="<?php echo e($editUrl($it)); ?>"><?php echo e(__('Edit')); ?></a>
                               <a class="btn small ghost" href="<?php echo e($mapUrl($it)); ?>"><?php echo e(__('Map')); ?></a>
     
                                <form method="POST" action="<?php echo e($destroyUrl($it)); ?>" style="display:inline;" onsubmit="return confirm('<?php echo e(__('Delete this itinerary?')); ?>');">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn small danger"><?php echo e(__('Delete')); ?></button>
                                </form>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>

        <?php if(method_exists($itineraries, 'links')): ?>
            <div style="margin-top:16px;">
                <?php echo e($itineraries->links()); ?>

            </div>
        <?php endif; ?>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.base', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/raph/Sites/vereego/resources/views/itins/index.blade.php ENDPATH**/ ?>