<?php $__env->startSection('title', __('Login')); ?>

<?php $__env->startSection('content'); ?>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <div class="wrap">
    <h2><?php echo e(__('login')); ?></h2>

    <?php if(session('error')): ?>
        <div class="alert danger"><?php echo e(session('error')); ?></div>
    <?php endif; ?>

    <?php if($errors->any()): ?>
        <div class="alert danger">
        <ul style="margin:0 0 0 16px;">
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $err): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><li><?php echo e($err); ?></li><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
        </div>
    <?php endif; ?>

    <section class="profile-card profile-card--main">

        <form method="POST" action="<?php echo e(route('login.post', ['locale' => app()->getLocale()])); ?>" class="profile-form">
            <?php echo csrf_field(); ?>
            <div class="" style="padding:16px; border-radius:12px; border:1px solid #e5e7eb; background:#fff;">

                <div class="profile-card profile-card--main">
                    <div class="field-grid">
                        <div class="field-group">
                            <label for="email"><?php echo e(__('Email')); ?></label>
                            <input id="email" type="email" name="email" value="<?php echo e(old('email')); ?>" required autofocus>
                        </div>
                        <div class="field-group">
                            <label for="password"><?php echo e(__('Password')); ?></label>
                            <input id="password" type="password" name="password" required>
                        </div>
                    </div>
                </div>

                <div class="field-grid actions">
                    <div class="field-group">
                        <label>
                            <input type="checkbox" name="remember"> <?php echo e(__('Remember me')); ?>

                        </label>
                    </div>
                    <div class="field-group">
                        <button type="submit" class="btn primary"><?php echo e(__('Login')); ?></button>
                    </div>
                    <div class="field-group">
                       <a href="<?php echo e(route('register', ['locale' => app()->getLocale()])); ?>" class="btn ghost"><?php echo e(__('Create account')); ?></a>
                    </div>
                </div>

                   
                <div style="margin-top:10px; text-align:right; font-size: 0.9em;">
                    <a class="btn ghost" href="<?php echo e(route('password.request')); ?>"><?php echo e(__('Forgot your password?')); ?></a>
                </div>
            </div>
        </form>
    </section>
 <?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.base', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/raph/Sites/vereego/resources/views/user/login.blade.php ENDPATH**/ ?>