import { defineConfig } from 'vite'
import laravel from 'laravel-vite-plugin'
import vue from '@vitejs/plugin-vue'

export default defineConfig({
    plugins: [
        laravel({
            input: ['resources/css/app.css', 'resources/js/app.js'],
            refresh: true,
        }),
        vue(),
    ],
    server: {
        host: '192.168.1.200',   // ou '127.0.0.1'
        port: 5173,
        strictPort: true,
        hmr: {
            host: '192.168.1.200', // même IP
            port: 5173,
            protocol: 'ws',
        },
    },
})